/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.impl.TabletIdImpl;

public class MutationsRejectedException
extends AccumuloException {
    private static final long serialVersionUID = 1L;
    private List<ConstraintViolationSummary> cvsl;
    private Map<TabletId, Set<SecurityErrorCode>> af;
    private Collection<String> es;
    private int unknownErrors;

    private static <K, V, L> Map<L, V> transformKeys(Map<K, V> map, Function<K, L> keyFunction) {
        HashMap<Object, V> ret = new HashMap<Object, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ret.put(keyFunction.apply(entry.getKey()), entry.getValue());
        }
        return ret;
    }

    @Deprecated
    public MutationsRejectedException(List<ConstraintViolationSummary> cvsList, HashMap<KeyExtent, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("# constraint violations : " + cvsList.size() + "  security codes: " + hashMap.values() + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl = cvsList;
        this.af = MutationsRejectedException.transformKeys(hashMap, TabletIdImpl.KE_2_TID_OLD);
        this.es = serverSideErrors;
        this.unknownErrors = unknownErrors;
    }

    @Deprecated
    public MutationsRejectedException(Instance instance, List<ConstraintViolationSummary> cvsList, HashMap<KeyExtent, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("# constraint violations : " + cvsList.size() + "  security codes: " + MutationsRejectedException.format(MutationsRejectedException.transformKeys(hashMap, TabletIdImpl.KE_2_TID_OLD), instance) + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl = cvsList;
        this.af = MutationsRejectedException.transformKeys(hashMap, TabletIdImpl.KE_2_TID_OLD);
        this.es = serverSideErrors;
        this.unknownErrors = unknownErrors;
    }

    public MutationsRejectedException(Instance instance, List<ConstraintViolationSummary> cvsList, Map<TabletId, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("# constraint violations : " + cvsList.size() + "  security codes: " + MutationsRejectedException.format(hashMap, instance) + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl = cvsList;
        this.af = hashMap;
        this.es = serverSideErrors;
        this.unknownErrors = unknownErrors;
    }

    private static String format(Map<TabletId, Set<SecurityErrorCode>> hashMap, Instance instance) {
        HashMap result = new HashMap();
        for (Map.Entry<TabletId, Set<SecurityErrorCode>> entry : hashMap.entrySet()) {
            String tableInfo = Tables.getPrintableTableInfoFromId(instance, entry.getKey().getTableId().toString());
            if (!result.containsKey(tableInfo)) {
                result.put(tableInfo, new HashSet());
            }
            ((Set)result.get(tableInfo)).addAll((Collection)hashMap.get(entry.getKey()));
        }
        return ((Object)result).toString();
    }

    public List<ConstraintViolationSummary> getConstraintViolationSummaries() {
        return this.cvsl;
    }

    @Deprecated
    public List<KeyExtent> getAuthorizationFailures() {
        return new ArrayList<KeyExtent>(Collections2.transform(this.af.keySet(), TabletIdImpl.TID_2_KE_OLD));
    }

    @Deprecated
    public Map<KeyExtent, Set<SecurityErrorCode>> getAuthorizationFailuresMap() {
        return MutationsRejectedException.transformKeys(this.af, TabletIdImpl.TID_2_KE_OLD);
    }

    public Map<TabletId, Set<SecurityErrorCode>> getSecurityErrorCodes() {
        return this.af;
    }

    public Collection<String> getErrorServers() {
        return this.es;
    }

    public int getUnknownExceptions() {
        return this.unknownErrors;
    }
}

