/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;

public class ScannerOptions
implements ScannerBase {
    protected List<IterInfo> serverSideIteratorList = Collections.emptyList();
    protected Map<String, Map<String, String>> serverSideIteratorOptions = Collections.emptyMap();
    protected SortedSet<Column> fetchedColumns = new TreeSet<Column>();
    protected long retryTimeout = Long.MAX_VALUE;
    protected long batchTimeout = Long.MAX_VALUE;
    private String regexIterName = null;
    private SamplerConfiguration samplerConfig = null;
    protected String classLoaderContext = null;

    protected ScannerOptions() {
    }

    public ScannerOptions(ScannerOptions so) {
        ScannerOptions.setOptions(this, so);
    }

    @Override
    public synchronized void addScanIterator(IteratorSetting si) {
        Map<String, String> opts;
        Preconditions.checkArgument((si != null ? 1 : 0) != 0, (Object)"si is null");
        if (this.serverSideIteratorList.size() == 0) {
            this.serverSideIteratorList = new ArrayList<IterInfo>();
        }
        for (IterInfo ii : this.serverSideIteratorList) {
            if (ii.iterName.equals(si.getName())) {
                throw new IllegalArgumentException("Iterator name is already in use " + si.getName());
            }
            if (ii.getPriority() != si.getPriority()) continue;
            throw new IllegalArgumentException("Iterator priority is already in use " + si.getPriority());
        }
        this.serverSideIteratorList.add(new IterInfo(si.getPriority(), si.getIteratorClass(), si.getName()));
        if (this.serverSideIteratorOptions.size() == 0) {
            this.serverSideIteratorOptions = new HashMap<String, Map<String, String>>();
        }
        if ((opts = this.serverSideIteratorOptions.get(si.getName())) == null) {
            opts = new HashMap<String, String>();
            this.serverSideIteratorOptions.put(si.getName(), opts);
        }
        opts.putAll(si.getOptions());
    }

    @Override
    public synchronized void removeScanIterator(String iteratorName) {
        Preconditions.checkArgument((iteratorName != null ? 1 : 0) != 0, (Object)"iteratorName is null");
        if (this.serverSideIteratorList.size() == 0) {
            return;
        }
        for (IterInfo ii : this.serverSideIteratorList) {
            if (!ii.iterName.equals(iteratorName)) continue;
            this.serverSideIteratorList.remove(ii);
            break;
        }
        this.serverSideIteratorOptions.remove(iteratorName);
    }

    @Override
    public synchronized void updateScanIteratorOption(String iteratorName, String key, String value) {
        Map<String, String> opts;
        Preconditions.checkArgument((iteratorName != null ? 1 : 0) != 0, (Object)"iteratorName is null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        if (this.serverSideIteratorOptions.size() == 0) {
            this.serverSideIteratorOptions = new HashMap<String, Map<String, String>>();
        }
        if ((opts = this.serverSideIteratorOptions.get(iteratorName)) == null) {
            opts = new HashMap<String, String>();
            this.serverSideIteratorOptions.put(iteratorName, opts);
        }
        opts.put(key, value);
    }

    @Override
    public synchronized void fetchColumnFamily(Text col) {
        Preconditions.checkArgument((col != null ? 1 : 0) != 0, (Object)"col is null");
        Column c = new Column(TextUtil.getBytes(col), null, null);
        this.fetchedColumns.add(c);
    }

    @Override
    public synchronized void fetchColumn(Text colFam, Text colQual) {
        Preconditions.checkArgument((colFam != null ? 1 : 0) != 0, (Object)"colFam is null");
        Preconditions.checkArgument((colQual != null ? 1 : 0) != 0, (Object)"colQual is null");
        Column c = new Column(TextUtil.getBytes(colFam), TextUtil.getBytes(colQual), null);
        this.fetchedColumns.add(c);
    }

    @Override
    public void fetchColumn(IteratorSetting.Column column) {
        Preconditions.checkArgument((column != null ? 1 : 0) != 0, (Object)"Column is null");
        this.fetchColumn(column.getColumnFamily(), column.getColumnQualifier());
    }

    @Override
    public synchronized void clearColumns() {
        this.fetchedColumns.clear();
    }

    public synchronized SortedSet<Column> getFetchedColumns() {
        return this.fetchedColumns;
    }

    @Override
    public synchronized void clearScanIterators() {
        this.serverSideIteratorList = Collections.emptyList();
        this.serverSideIteratorOptions = Collections.emptyMap();
        this.regexIterName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setOptions(ScannerOptions dst, ScannerOptions src) {
        ScannerOptions scannerOptions = dst;
        synchronized (scannerOptions) {
            ScannerOptions scannerOptions2 = src;
            synchronized (scannerOptions2) {
                dst.regexIterName = src.regexIterName;
                dst.fetchedColumns = new TreeSet<Column>(src.fetchedColumns);
                dst.serverSideIteratorList = new ArrayList<IterInfo>(src.serverSideIteratorList);
                dst.classLoaderContext = src.classLoaderContext;
                dst.serverSideIteratorOptions = new HashMap<String, Map<String, String>>();
                Set<Map.Entry<String, Map<String, String>>> es = src.serverSideIteratorOptions.entrySet();
                for (Map.Entry<String, Map<String, String>> entry : es) {
                    dst.serverSideIteratorOptions.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
                }
                dst.samplerConfig = src.samplerConfig;
                dst.batchTimeout = src.batchTimeout;
            }
        }
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setTimeout(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("retry timeout must be positive : " + timeout);
        }
        this.retryTimeout = timeout == 0L ? Long.MAX_VALUE : timeUnit.toMillis(timeout);
    }

    @Override
    public synchronized long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.retryTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized Authorizations getAuthorizations() {
        throw new UnsupportedOperationException("No authorizations to return");
    }

    @Override
    public synchronized void setSamplerConfiguration(SamplerConfiguration samplerConfig) {
        Objects.requireNonNull(samplerConfig);
        this.samplerConfig = samplerConfig;
    }

    @Override
    public synchronized SamplerConfiguration getSamplerConfiguration() {
        return this.samplerConfig;
    }

    @Override
    public synchronized void clearSamplerConfiguration() {
        this.samplerConfig = null;
    }

    @Override
    public void setBatchTimeout(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Batch timeout must be positive : " + timeout);
        }
        this.batchTimeout = timeout == 0L ? Long.MAX_VALUE : timeUnit.toMillis(timeout);
    }

    @Override
    public long getBatchTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.batchTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setClassLoaderContext(String classLoaderContext) {
        Objects.requireNonNull(classLoaderContext, "classloader context name cannot be null");
        this.classLoaderContext = classLoaderContext;
    }

    @Override
    public void clearClassLoaderContext() {
        this.classLoaderContext = null;
    }

    @Override
    public String getClassLoaderContext() {
        return this.classLoaderContext;
    }
}

