/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.constraints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.ConstraintViolationSummary;

public class Violations {
    private HashMap<CVSKey, ConstraintViolationSummary> cvsmap = new HashMap();

    public boolean isEmpty() {
        return this.cvsmap.isEmpty();
    }

    private void add(CVSKey cvsk, ConstraintViolationSummary cvs) {
        ConstraintViolationSummary existingCvs = this.cvsmap.get(cvsk);
        if (existingCvs == null) {
            this.cvsmap.put(cvsk, cvs);
        } else {
            existingCvs.numberOfViolatingMutations += cvs.numberOfViolatingMutations;
        }
    }

    public void add(ConstraintViolationSummary cvs) {
        CVSKey cvsk = new CVSKey(cvs);
        this.add(cvsk, cvs);
    }

    public void add(Violations violations) {
        Set<Map.Entry<CVSKey, ConstraintViolationSummary>> es = violations.cvsmap.entrySet();
        for (Map.Entry<CVSKey, ConstraintViolationSummary> entry : es) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void add(List<ConstraintViolationSummary> cvsList) {
        for (ConstraintViolationSummary constraintViolationSummary : cvsList) {
            this.add(constraintViolationSummary);
        }
    }

    public List<ConstraintViolationSummary> asList() {
        return new ArrayList<ConstraintViolationSummary>(this.cvsmap.values());
    }

    private static class CVSKey {
        private String className;
        private short vcode;

        CVSKey(ConstraintViolationSummary cvs) {
            this.className = cvs.constrainClass;
            this.vcode = cvs.violationCode;
        }

        public int hashCode() {
            return this.className.hashCode() + this.vcode;
        }

        public boolean equals(Object o) {
            if (o instanceof CVSKey) {
                return this.equals((CVSKey)o);
            }
            return false;
        }

        public boolean equals(CVSKey ocvsk) {
            return this.className.equals(ocvsk.className) && this.vcode == ocvsk.vcode;
        }
    }
}

