/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;

public class CachedEntity<T> {
    private final AtomicReference<T> entryDataRef = new AtomicReference<Object>(null);
    private final Clock cacheClock;
    private final long expiryDurationMS;
    private volatile long entryTimeStamp;

    public CachedEntity(TimeUnit expiryTimeUnit, long expiryLength, Clock clock) {
        this.cacheClock = clock;
        this.expiryDurationMS = TimeUnit.MILLISECONDS.convert(expiryLength, expiryTimeUnit);
        this.entryTimeStamp = 0L;
    }

    public CachedEntity(TimeUnit expiryTimeUnit, long expiryLength) {
        this(expiryTimeUnit, expiryLength, (Clock)new MonotonicClock());
    }

    public boolean isExpired() {
        return this.entryTimeStamp == 0L || this.cacheClock.getTime() - this.entryTimeStamp > this.expiryDurationMS;
    }

    public T getValue() {
        if (this.isExpired() && this.clearExpiredEntry()) {
            return null;
        }
        return this.entryDataRef.get();
    }

    public void setValue(T newEntry) {
        T currentEntry = this.entryDataRef.get();
        while (!this.entryDataRef.compareAndSet(currentEntry, newEntry)) {
            currentEntry = this.entryDataRef.get();
        }
        this.entryTimeStamp = this.cacheClock.getTime();
    }

    public void enforceExpiration() {
        this.entryTimeStamp = 0L;
    }

    private boolean clearExpiredEntry() {
        T currentEntry = this.entryDataRef.get();
        if (currentEntry == null) {
            return true;
        }
        return this.entryDataRef.compareAndSet(currentEntry, null);
    }
}

