/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.runtime.api.Event;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class InputInitializerEvent
extends Event {
    private String targetVertexName;
    private String targetInputName;
    private ByteBuffer eventPayload;
    private String sourceVertexName;

    private InputInitializerEvent(String targetVertexName, String targetInputName, ByteBuffer eventPayload) {
        Objects.requireNonNull(targetVertexName, "TargetVertexName cannot be null");
        Objects.requireNonNull(targetInputName, "TargetInputName cannot be null");
        this.targetVertexName = targetVertexName;
        this.targetInputName = targetInputName;
        this.eventPayload = eventPayload;
    }

    public static InputInitializerEvent create(String targetVertexName, String targetInputName, ByteBuffer eventPayload) {
        return new InputInitializerEvent(targetVertexName, targetInputName, eventPayload);
    }

    public String getTargetVertexName() {
        return this.targetVertexName;
    }

    public String getTargetInputName() {
        return this.targetInputName;
    }

    public ByteBuffer getUserPayload() {
        return this.eventPayload == null ? null : this.eventPayload.asReadOnlyBuffer();
    }

    @InterfaceAudience.Private
    public void setSourceVertexName(String srcVertexName) {
        this.sourceVertexName = srcVertexName;
    }

    public String getSourceVertexName() {
        return this.sourceVertexName;
    }

    public String toString() {
        return "[TargetVertexName=" + this.targetVertexName + ", TargetInputName=" + this.targetInputName + ", SourceVertexName=" + this.sourceVertexName + " Payload=" + this.eventPayload + "]";
    }
}

