/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataTraceFlag is the corresponding interface of BACnetConstructedDataTraceFlag
type BACnetConstructedDataTraceFlag interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetTraceFlag returns TraceFlag (property field)
	GetTraceFlag() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataTraceFlag is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataTraceFlag()
	// CreateBuilder creates a BACnetConstructedDataTraceFlagBuilder
	CreateBACnetConstructedDataTraceFlagBuilder() BACnetConstructedDataTraceFlagBuilder
}

// _BACnetConstructedDataTraceFlag is the data-structure of this message
type _BACnetConstructedDataTraceFlag struct {
	BACnetConstructedDataContract
	TraceFlag BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataTraceFlag = (*_BACnetConstructedDataTraceFlag)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataTraceFlag)(nil)

// NewBACnetConstructedDataTraceFlag factory function for _BACnetConstructedDataTraceFlag
func NewBACnetConstructedDataTraceFlag(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, traceFlag BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataTraceFlag {
	if traceFlag == nil {
		panic("traceFlag of type BACnetApplicationTagBoolean for BACnetConstructedDataTraceFlag must not be nil")
	}
	_result := &_BACnetConstructedDataTraceFlag{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		TraceFlag:                     traceFlag,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataTraceFlagBuilder is a builder for BACnetConstructedDataTraceFlag
type BACnetConstructedDataTraceFlagBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(traceFlag BACnetApplicationTagBoolean) BACnetConstructedDataTraceFlagBuilder
	// WithTraceFlag adds TraceFlag (property field)
	WithTraceFlag(BACnetApplicationTagBoolean) BACnetConstructedDataTraceFlagBuilder
	// WithTraceFlagBuilder adds TraceFlag (property field) which is build by the builder
	WithTraceFlagBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataTraceFlagBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataTraceFlag or returns an error if something is wrong
	Build() (BACnetConstructedDataTraceFlag, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataTraceFlag
}

// NewBACnetConstructedDataTraceFlagBuilder() creates a BACnetConstructedDataTraceFlagBuilder
func NewBACnetConstructedDataTraceFlagBuilder() BACnetConstructedDataTraceFlagBuilder {
	return &_BACnetConstructedDataTraceFlagBuilder{_BACnetConstructedDataTraceFlag: new(_BACnetConstructedDataTraceFlag)}
}

type _BACnetConstructedDataTraceFlagBuilder struct {
	*_BACnetConstructedDataTraceFlag

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataTraceFlagBuilder) = (*_BACnetConstructedDataTraceFlagBuilder)(nil)

func (b *_BACnetConstructedDataTraceFlagBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataTraceFlag
}

func (b *_BACnetConstructedDataTraceFlagBuilder) WithMandatoryFields(traceFlag BACnetApplicationTagBoolean) BACnetConstructedDataTraceFlagBuilder {
	return b.WithTraceFlag(traceFlag)
}

func (b *_BACnetConstructedDataTraceFlagBuilder) WithTraceFlag(traceFlag BACnetApplicationTagBoolean) BACnetConstructedDataTraceFlagBuilder {
	b.TraceFlag = traceFlag
	return b
}

func (b *_BACnetConstructedDataTraceFlagBuilder) WithTraceFlagBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataTraceFlagBuilder {
	builder := builderSupplier(b.TraceFlag.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.TraceFlag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataTraceFlagBuilder) Build() (BACnetConstructedDataTraceFlag, error) {
	if b.TraceFlag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'traceFlag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataTraceFlag.deepCopy(), nil
}

func (b *_BACnetConstructedDataTraceFlagBuilder) MustBuild() BACnetConstructedDataTraceFlag {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataTraceFlagBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataTraceFlagBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataTraceFlagBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataTraceFlagBuilder().(*_BACnetConstructedDataTraceFlagBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataTraceFlagBuilder creates a BACnetConstructedDataTraceFlagBuilder
func (b *_BACnetConstructedDataTraceFlag) CreateBACnetConstructedDataTraceFlagBuilder() BACnetConstructedDataTraceFlagBuilder {
	if b == nil {
		return NewBACnetConstructedDataTraceFlagBuilder()
	}
	return &_BACnetConstructedDataTraceFlagBuilder{_BACnetConstructedDataTraceFlag: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataTraceFlag) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataTraceFlag) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_TRACE_FLAG
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataTraceFlag) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataTraceFlag) GetTraceFlag() BACnetApplicationTagBoolean {
	return m.TraceFlag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataTraceFlag) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetTraceFlag())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataTraceFlag(structType any) BACnetConstructedDataTraceFlag {
	if casted, ok := structType.(BACnetConstructedDataTraceFlag); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataTraceFlag); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataTraceFlag) GetTypeName() string {
	return "BACnetConstructedDataTraceFlag"
}

func (m *_BACnetConstructedDataTraceFlag) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (traceFlag)
	lengthInBits += m.TraceFlag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataTraceFlag) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataTraceFlag) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataTraceFlag BACnetConstructedDataTraceFlag, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataTraceFlag"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataTraceFlag")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	traceFlag, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "traceFlag", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'traceFlag' field"))
	}
	m.TraceFlag = traceFlag

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), traceFlag)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataTraceFlag"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataTraceFlag")
	}

	return m, nil
}

func (m *_BACnetConstructedDataTraceFlag) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataTraceFlag) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataTraceFlag"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataTraceFlag")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "traceFlag", m.GetTraceFlag(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'traceFlag' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataTraceFlag"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataTraceFlag")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataTraceFlag) IsBACnetConstructedDataTraceFlag() {}

func (m *_BACnetConstructedDataTraceFlag) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataTraceFlag) deepCopy() *_BACnetConstructedDataTraceFlag {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataTraceFlagCopy := &_BACnetConstructedDataTraceFlag{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.TraceFlag),
	}
	_BACnetConstructedDataTraceFlagCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataTraceFlagCopy
}

func (m *_BACnetConstructedDataTraceFlag) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
