/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.math.BigInteger;
import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SpanContextDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19748;
  }

  // Properties.
  protected final GuidValue traceId;
  protected final BigInteger spanId;

  public SpanContextDataType(GuidValue traceId, BigInteger spanId) {
    super();
    this.traceId = traceId;
    this.spanId = spanId;
  }

  public GuidValue getTraceId() {
    return traceId;
  }

  public BigInteger getSpanId() {
    return spanId;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SpanContextDataType");

    // Simple Field (traceId)
    writeSimpleField("traceId", traceId, writeComplex(writeBuffer));

    // Simple Field (spanId)
    writeSimpleField("spanId", spanId, writeUnsignedBigInteger(writeBuffer, 64));

    writeBuffer.popContext("SpanContextDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SpanContextDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (traceId)
    lengthInBits += traceId.getLengthInBits();

    // Simple field (spanId)
    lengthInBits += 64;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("SpanContextDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    GuidValue traceId =
        readSimpleField(
            "traceId", readComplex(() -> GuidValue.staticParse(readBuffer), readBuffer));

    BigInteger spanId = readSimpleField("spanId", readUnsignedBigInteger(readBuffer, 64));

    readBuffer.closeContext("SpanContextDataType");
    // Create the instance
    return new SpanContextDataTypeBuilderImpl(traceId, spanId);
  }

  public static class SpanContextDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final GuidValue traceId;
    private final BigInteger spanId;

    public SpanContextDataTypeBuilderImpl(GuidValue traceId, BigInteger spanId) {
      this.traceId = traceId;
      this.spanId = spanId;
    }

    public SpanContextDataType build() {
      SpanContextDataType spanContextDataType = new SpanContextDataType(traceId, spanId);
      return spanContextDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SpanContextDataType)) {
      return false;
    }
    SpanContextDataType that = (SpanContextDataType) o;
    return (getTraceId() == that.getTraceId())
        && (getSpanId() == that.getSpanId())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTraceId(), getSpanId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
