/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.TopicPolicies;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.util.RelativeTimeUtil;

@Parameters(commandDescription="Operations on persistent topics")
public class CmdTopicPolicies
extends CmdBase {
    public CmdTopicPolicies(Supplier<PulsarAdmin> admin) {
        super("topicPolicies", admin);
        this.jcommander.addCommand("get-message-ttl", (Object)new GetMessageTTL());
        this.jcommander.addCommand("set-message-ttl", (Object)new SetMessageTTL());
        this.jcommander.addCommand("remove-message-ttl", (Object)new RemoveMessageTTL());
        this.jcommander.addCommand("get-max-unacked-messages-per-consumer", (Object)new GetMaxUnackedMessagesPerConsumer());
        this.jcommander.addCommand("set-max-unacked-messages-per-consumer", (Object)new SetMaxUnackedMessagesPerConsumer());
        this.jcommander.addCommand("remove-max-unacked-messages-per-consumer", (Object)new RemoveMaxUnackedMessagesPerConsumer());
        this.jcommander.addCommand("get-max-consumers-per-subscription", (Object)new GetMaxConsumersPerSubscription());
        this.jcommander.addCommand("set-max-consumers-per-subscription", (Object)new SetMaxConsumersPerSubscription());
        this.jcommander.addCommand("remove-max-consumers-per-subscription", (Object)new RemoveMaxConsumersPerSubscription());
        this.jcommander.addCommand("set-subscription-types-enabled", (Object)new SetSubscriptionTypesEnabled());
        this.jcommander.addCommand("get-subscription-types-enabled", (Object)new GetSubscriptionTypesEnabled());
        this.jcommander.addCommand("remove-subscription-types-enabled", (Object)new RemoveSubscriptionTypesEnabled());
        this.jcommander.addCommand("get-retention", (Object)new GetRetention());
        this.jcommander.addCommand("set-retention", (Object)new SetRetention());
        this.jcommander.addCommand("remove-retention", (Object)new RemoveRetention());
        this.jcommander.addCommand("get-backlog-quota", (Object)new GetBacklogQuotaMap());
        this.jcommander.addCommand("set-backlog-quota", (Object)new SetBacklogQuota());
        this.jcommander.addCommand("remove-backlog-quota", (Object)new RemoveBacklogQuota());
        this.jcommander.addCommand("get-max-producers", (Object)new GetMaxProducers());
        this.jcommander.addCommand("set-max-producers", (Object)new SetMaxProducers());
        this.jcommander.addCommand("remove-max-producers", (Object)new RemoveMaxProducers());
        this.jcommander.addCommand("get-max-message-size", (Object)new GetMaxMessageSize());
        this.jcommander.addCommand("set-max-message-size", (Object)new SetMaxMessageSize());
        this.jcommander.addCommand("remove-max-message-size", (Object)new RemoveMaxMessageSize());
        this.jcommander.addCommand("set-deduplication", (Object)new SetDeduplicationStatus());
        this.jcommander.addCommand("get-deduplication", (Object)new GetDeduplicationStatus());
        this.jcommander.addCommand("remove-deduplication", (Object)new RemoveDeduplicationStatus());
        this.jcommander.addCommand("get-deduplication-snapshot-interval", (Object)new GetDeduplicationSnapshotInterval());
        this.jcommander.addCommand("set-deduplication-snapshot-interval", (Object)new SetDeduplicationSnapshotInterval());
        this.jcommander.addCommand("remove-deduplication-snapshot-interval", (Object)new RemoveDeduplicationSnapshotInterval());
        this.jcommander.addCommand("get-persistence", (Object)new GetPersistence());
        this.jcommander.addCommand("set-persistence", (Object)new SetPersistence());
        this.jcommander.addCommand("remove-persistence", (Object)new RemovePersistence());
        this.jcommander.addCommand("get-subscription-dispatch-rate", (Object)new GetSubscriptionDispatchRate());
        this.jcommander.addCommand("set-subscription-dispatch-rate", (Object)new SetSubscriptionDispatchRate());
        this.jcommander.addCommand("remove-subscription-dispatch-rate", (Object)new RemoveSubscriptionDispatchRate());
        this.jcommander.addCommand("get-replicator-dispatch-rate", (Object)new GetReplicatorDispatchRate());
        this.jcommander.addCommand("set-replicator-dispatch-rate", (Object)new SetReplicatorDispatchRate());
        this.jcommander.addCommand("remove-replicator-dispatch-rate", (Object)new RemoveReplicatorDispatchRate());
        this.jcommander.addCommand("get-publish-rate", (Object)new GetPublishRate());
        this.jcommander.addCommand("set-publish-rate", (Object)new SetPublishRate());
        this.jcommander.addCommand("remove-publish-rate", (Object)new RemovePublishRate());
        this.jcommander.addCommand("get-compaction-threshold", (Object)new GetCompactionThreshold());
        this.jcommander.addCommand("set-compaction-threshold", (Object)new SetCompactionThreshold());
        this.jcommander.addCommand("remove-compaction-threshold", (Object)new RemoveCompactionThreshold());
        this.jcommander.addCommand("get-subscribe-rate", (Object)new GetSubscribeRate());
        this.jcommander.addCommand("set-subscribe-rate", (Object)new SetSubscribeRate());
        this.jcommander.addCommand("remove-subscribe-rate", (Object)new RemoveSubscribeRate());
        this.jcommander.addCommand("get-max-consumers", (Object)new GetMaxConsumers());
        this.jcommander.addCommand("set-max-consumers", (Object)new SetMaxConsumers());
        this.jcommander.addCommand("remove-max-consumers", (Object)new RemoveMaxConsumers());
        this.jcommander.addCommand("get-delayed-delivery", (Object)new GetDelayedDelivery());
        this.jcommander.addCommand("set-delayed-delivery", (Object)new SetDelayedDelivery());
        this.jcommander.addCommand("remove-delayed-delivery", (Object)new RemoveDelayedDelivery());
        this.jcommander.addCommand("get-dispatch-rate", (Object)new GetDispatchRate());
        this.jcommander.addCommand("set-dispatch-rate", (Object)new SetDispatchRate());
        this.jcommander.addCommand("remove-dispatch-rate", (Object)new RemoveDispatchRate());
        this.jcommander.addCommand("get-offload-policies", (Object)new GetOffloadPolicies());
        this.jcommander.addCommand("set-offload-policies", (Object)new SetOffloadPolicies());
        this.jcommander.addCommand("remove-offload-policies", (Object)new RemoveOffloadPolicies());
        this.jcommander.addCommand("get-max-unacked-messages-per-subscription", (Object)new GetMaxUnackedMessagesPerSubscription());
        this.jcommander.addCommand("set-max-unacked-messages-per-subscription", (Object)new SetMaxUnackedMessagesPerSubscription());
        this.jcommander.addCommand("remove-max-unacked-messages-per-subscription", (Object)new RemoveMaxUnackedMessagesPerSubscription());
        this.jcommander.addCommand("get-inactive-topic-policies", (Object)new GetInactiveTopicPolicies());
        this.jcommander.addCommand("set-inactive-topic-policies", (Object)new SetInactiveTopicPolicies());
        this.jcommander.addCommand("remove-inactive-topic-policies", (Object)new RemoveInactiveTopicPolicies());
        this.jcommander.addCommand("get-max-subscriptions-per-topic", (Object)new GetMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("set-max-subscriptions-per-topic", (Object)new SetMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("remove-max-subscriptions-per-topic", (Object)new RemoveMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("remove-schema-compatibility-strategy", (Object)new RemoveSchemaCompatibilityStrategy());
        this.jcommander.addCommand("set-schema-compatibility-strategy", (Object)new SetSchemaCompatibilityStrategy());
        this.jcommander.addCommand("get-schema-compatibility-strategy", (Object)new GetSchemaCompatibilityStrategy());
        this.jcommander.addCommand("get-entry-filters-per-topic", (Object)new GetEntryFiltersPerTopic());
        this.jcommander.addCommand("set-entry-filters-per-topic", (Object)new SetEntryFiltersPerTopic());
        this.jcommander.addCommand("remove-entry-filters-per-topic", (Object)new RemoveEntryFiltersPerTopic());
        this.jcommander.addCommand("set-auto-subscription-creation", (Object)new SetAutoSubscriptionCreation());
        this.jcommander.addCommand("get-auto-subscription-creation", (Object)new GetAutoSubscriptionCreation());
        this.jcommander.addCommand("remove-auto-subscription-creation", (Object)new RemoveAutoSubscriptionCreation());
    }

    private TopicPolicies getTopicPolicies(boolean isGlobal) {
        return this.getAdmin().topicPolicies(isGlobal);
    }

    @Parameters(commandDescription="Get the message TTL for a topic")
    private class GetMessageTTL
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageTTL.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMessageTTL(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set message TTL for a topic")
    private class SetMessageTTL
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--ttl"}, description="Message TTL for topic in seconds (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w), allowed range from 1 to Integer.MAX_VALUE", required=true)
        private String messageTTLStr;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private SetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            long messageTTLInSecond;
            try {
                messageTTLInSecond = RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.messageTTLStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(e.getMessage());
            }
            if (messageTTLInSecond < 0L || messageTTLInSecond > Integer.MAX_VALUE) {
                throw new ParameterException(String.format("Message TTL cannot be negative or greater than %d seconds", Integer.MAX_VALUE));
            }
            String persistentTopic = SetMessageTTL.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMessageTTL(persistentTopic, (int)messageTTLInSecond);
        }
    }

    @Parameters(commandDescription="Remove message TTL for a topic")
    private class RemoveMessageTTL
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private RemoveMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMessageTTL.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMessageTTL(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max unacked messages policy per consumer for a topic")
    private class GetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesPerConsumer.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxUnackedMessagesOnConsumer(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set max unacked messages policy per consumer for a topic")
    private class SetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-m", "--maxNum"}, description="max unacked messages num on consumer", required=true)
        private int maxNum;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private SetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesPerConsumer.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxUnackedMessagesOnConsumer(persistentTopic, this.maxNum);
        }
    }

    @Parameters(commandDescription="Remove max unacked messages policy per consumer for a topic")
    private class RemoveMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private RemoveMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesPerConsumer.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxUnackedMessagesOnConsumer(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max consumers per subscription for a topic")
    private class GetMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumersPerSubscription.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxConsumersPerSubscription(persistentTopic));
        }
    }

    @Parameters(commandDescription="Set max consumers per subscription for a topic")
    private class SetMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-consumers-per-subscription", "-c"}, description="maxConsumersPerSubscription for a namespace", required=true)
        private int maxConsumersPerSubscription;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private SetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumersPerSubscription.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxConsumersPerSubscription(persistentTopic, this.maxConsumersPerSubscription);
        }
    }

    @Parameters(commandDescription="Remove max consumers per subscription for a topic")
    private class RemoveMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private RemoveMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumersPerSubscription.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxConsumersPerSubscription(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set subscription types enabled for a topic")
    private class SetSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--types", "-t"}, description="Subscription types enabled list (comma separated values). Possible values: (Exclusive, Shared, Failover, Key_Shared).", required=true)
        private List<String> subTypes;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private SetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionTypesEnabled.validatePersistentTopic(this.params);
            HashSet types = new HashSet();
            this.subTypes.forEach(s -> {
                SubscriptionType subType;
                try {
                    subType = SubscriptionType.valueOf((String)s);
                }
                catch (IllegalArgumentException exception) {
                    throw new ParameterException(String.format("Illegal subscription type %s. Possible values: %s.", s, Arrays.toString(SubscriptionType.values())));
                }
                types.add(subType);
            });
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscriptionTypesEnabled(persistentTopic, types);
        }
    }

    @Parameters(commandDescription="Get subscription types enabled for a topic")
    private class GetSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private GetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionTypesEnabled.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscriptionTypesEnabled(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove subscription types enabled for a topic")
    private class RemoveSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscriptionTypesEnabled.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscriptionTypesEnabled(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the retention policy for a topic")
    private class GetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, the broker returns global topic policiesIf set to false or not set, the broker returns local topic policies")
        private boolean isGlobal = false;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetRetention.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getRetention(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set the retention policy for a topic")
    private class SetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--time", "-t"}, description="Retention time with optional time unit suffix. For example, 100m, 3h, 2d, 5w. If the time unit is not specified, the default unit is seconds. For example, -t 120 sets retention to 2 minutes. 0 means no retention and -1 means infinite time retention.", required=true)
        private String retentionTimeStr;
        @Parameter(names={"--size", "-s"}, description="Retention size limit with optional size unit suffix. For example, 4096, 10M, 16G, 3T.  The size unit suffix character can be k/K, m/M, g/G, or t/T.  If the size unit suffix is not specified, the default unit is bytes. 0 or less than 1MB means no retention and -1 means infinite size retention", required=true)
        private String limitStr;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy is replicated to other clusters asynchronously, If set to false or not set, the topic retention policy is replicated to local clusters.")
        private boolean isGlobal = false;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetRetention.validatePersistentTopic(this.params);
            long sizeLimit = SetRetention.validateSizeString(this.limitStr);
            long retentionTimeInSec = RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.retentionTimeStr);
            int retentionTimeInMin = retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(retentionTimeInSec) : -1;
            int retentionSizeInMB = sizeLimit != -1L ? (int)(sizeLimit / 0x100000L) : -1;
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setRetention(persistentTopic, new RetentionPolicies(retentionTimeInMin, (long)retentionSizeInMB));
        }
    }

    @Parameters(commandDescription="Remove the retention policy for a topic")
    private class RemoveRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation is replicated to other clusters asynchronouslyIf set to false or not set, the topic retention policy is replicated to local clusters.")
        private boolean isGlobal = false;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveRetention.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeRetention(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the backlog quota policies for a topic")
    private class GetBacklogQuotaMap
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetBacklogQuotaMap() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetBacklogQuotaMap.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getBacklogQuotaMap(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set a backlog quota policy for a topic")
    private class SetBacklogQuota
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-l", "--limit"}, description="Size limit (eg: 10M, 16G)")
        private String limitStr = null;
        @Parameter(names={"-lt", "--limitTime"}, description="Time limit in second (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w), non-positive number for disabling time limit.")
        private String limitTimeStr = null;
        @Parameter(names={"-p", "--policy"}, description="Retention policy to enforce when the limit is reached. Valid options are: [producer_request_hold, producer_exception, consumer_backlog_eviction]", required=true)
        private String policyStr;
        @Parameter(names={"-t", "--type"}, description="Backlog quota type to set. Valid options are: destination_storage (default) and message_age. destination_storage limits backlog by size. message_age limits backlog by time, that is, message timestamp (broker or publish timestamp). You can set size or time to control the backlog, or combine them together to control the backlog. ")
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            BacklogQuota.RetentionPolicy policy;
            try {
                policy = BacklogQuota.RetentionPolicy.valueOf((String)this.policyStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid retention policy type '%s'. Valid options are: %s", this.policyStr, Arrays.toString(BacklogQuota.RetentionPolicy.values())));
            }
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            String persistentTopic = SetBacklogQuota.validatePersistentTopic(this.params);
            BacklogQuota.Builder builder = BacklogQuota.builder().retentionPolicy(policy);
            if (backlogQuotaType == BacklogQuota.BacklogQuotaType.destination_storage) {
                if (this.limitStr == null) {
                    throw new ParameterException("Quota type of 'destination_storage' needs a size limit");
                }
                long limit = SetBacklogQuota.validateSizeString(this.limitStr);
                builder.limitSize((long)((int)limit));
            } else {
                long limitTimeInSec;
                if (this.limitTimeStr == null) {
                    throw new ParameterException("Quota type of 'message_age' needs a time limit");
                }
                try {
                    limitTimeInSec = RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.limitTimeStr);
                }
                catch (IllegalArgumentException e) {
                    throw new ParameterException(e.getMessage());
                }
                if (limitTimeInSec > Integer.MAX_VALUE) {
                    throw new ParameterException(String.format("Time limit cannot be greater than %d seconds", Integer.MAX_VALUE));
                }
                builder.limitTime((int)limitTimeInSec);
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setBacklogQuota(persistentTopic, builder.build(), backlogQuotaType);
        }
    }

    @Parameters(commandDescription="Remove a backlog quota policy from a topic")
    private class RemoveBacklogQuota
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--type"}, description="Backlog quota type to remove")
        private String backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage.name();
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveBacklogQuota.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeBacklogQuota(persistentTopic, BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaType));
        }
    }

    @Parameters(commandDescription="Get max number of producers for a topic")
    private class GetMaxProducers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxProducers.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxProducers(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set max number of producers for a topic")
    private class SetMaxProducers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-producers", "-p"}, description="Max producers for a topic", required=true)
        private int maxProducers;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal;

        private SetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxProducers.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxProducers(persistentTopic, this.maxProducers);
        }
    }

    @Parameters(commandDescription="Remove max number of producers for a topic")
    private class RemoveMaxProducers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxProducers.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxProducers(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max message size for a topic")
    private class GetMaxMessageSize
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returns global topic policies")
        private boolean isGlobal = false;

        private GetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxMessageSize.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxMessageSize(persistentTopic));
        }
    }

    @Parameters(commandDescription="Set max message size for a topic")
    private class SetMaxMessageSize
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-message-size", "-m"}, description="Max message size for a topic", required=true)
        private int maxMessageSize;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally.")
        private boolean isGlobal = false;

        private SetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxMessageSize.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxMessageSize(persistentTopic, this.maxMessageSize);
        }
    }

    @Parameters(commandDescription="Remove max message size for a topic")
    private class RemoveMaxMessageSize
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. ")
        private boolean isGlobal = false;

        private RemoveMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxMessageSize.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxMessageSize(persistentTopic);
        }
    }

    @Parameters(commandDescription="Enable or disable status for a topic")
    private class SetDeduplicationStatus
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable deduplication")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable deduplication")
        private boolean disable = false;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDeduplicationStatus.validatePersistentTopic(this.params);
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDeduplicationStatus(persistentTopic, this.enable);
        }
    }

    @Parameters(commandDescription="Get the deduplication status for a topic")
    private class GetDeduplicationStatus
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. ")
        private boolean isGlobal = false;

        private GetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationStatus.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDeduplicationStatus(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove the deduplication status for a topic")
    private class RemoveDeduplicationStatus
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationStatus.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDeduplicationStatus(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get deduplication snapshot interval for a topic")
    private class GetDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returns global topic policies")
        private boolean isGlobal = false;

        private GetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationSnapshotInterval.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDeduplicationSnapshotInterval(persistentTopic));
        }
    }

    @Parameters(commandDescription="Set deduplication snapshot interval for a topic")
    private class SetDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-i", "--interval"}, description="Deduplication snapshot interval for topic in second, allowed range from 0 to Integer.MAX_VALUE", required=true)
        private int interval;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally.")
        private boolean isGlobal = false;

        private SetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.interval < 0) {
                throw new ParameterException(String.format("Invalid interval '%d'. ", this.interval));
            }
            String persistentTopic = SetDeduplicationSnapshotInterval.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDeduplicationSnapshotInterval(persistentTopic, this.interval);
        }
    }

    @Parameters(commandDescription="Remove deduplication snapshot interval for a topic")
    private class RemoveDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. ")
        private boolean isGlobal = false;

        private RemoveDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationSnapshotInterval.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDeduplicationSnapshotInterval(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the persistence policies for a topic")
    private class GetPersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies", arity=0)
        private boolean isGlobal = false;

        private GetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPersistence.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getPersistence(persistentTopic));
        }
    }

    @Parameters(commandDescription="Set the persistence policies for a topic")
    private class SetPersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-e", "--bookkeeper-ensemble"}, description="Number of bookies to use for a topic")
        private int bookkeeperEnsemble = 2;
        @Parameter(names={"-w", "--bookkeeper-write-quorum"}, description="How many writes to make of each entry")
        private int bookkeeperWriteQuorum = 2;
        @Parameter(names={"-a", "--bookkeeper-ack-quorum"}, description="Number of acks (guaranteed copies) to wait for each entry")
        private int bookkeeperAckQuorum = 2;
        @Parameter(names={"-r", "--ml-mark-delete-max-rate"}, description="Throttling rate of mark-delete operation (0 means no throttle)")
        private double managedLedgerMaxMarkDeleteRate = 0.0;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously", arity=0)
        private boolean isGlobal = false;

        private SetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPersistence.validatePersistentTopic(this.params);
            if (this.bookkeeperEnsemble <= 0 || this.bookkeeperWriteQuorum <= 0 || this.bookkeeperAckQuorum <= 0) {
                throw new ParameterException("[--bookkeeper-ensemble], [--bookkeeper-write-quorum] and [--bookkeeper-ack-quorum] must greater than 0.");
            }
            if (this.managedLedgerMaxMarkDeleteRate < 0.0) {
                throw new ParameterException("[--ml-mark-delete-max-rate] cannot less than 0.");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setPersistence(persistentTopic, new PersistencePolicies(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate));
        }
    }

    @Parameters(commandDescription="Remove the persistence policy for a topic")
    private class RemovePersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously", arity=0)
        private boolean isGlobal = false;

        private RemovePersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePersistence.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removePersistence(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get subscription message-dispatch-rate for a topic")
    private class GetSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;
        @Parameter(names={"--subscription", "-s"}, description="Get message-dispatch-rate of a specific subscription")
        private String subName;

        private GetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionDispatchRate.validatePersistentTopic(this.params);
            if (StringUtils.isBlank((CharSequence)this.subName)) {
                this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscriptionDispatchRate(persistentTopic, this.applied));
            } else {
                this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscriptionDispatchRate(persistentTopic, this.subName, this.applied));
            }
        }
    }

    @Parameters(commandDescription="Set subscription message-dispatch-rate for a topic")
    private class SetSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)")
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)")
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)")
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))")
        private boolean relativeToPublishRate = false;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;
        @Parameter(names={"--subscription", "-s"}, description="Set message-dispatch-rate for a specific subscription")
        private String subName;

        private SetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionDispatchRate.validatePersistentTopic(this.params);
            DispatchRate rate = DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build();
            if (StringUtils.isBlank((CharSequence)this.subName)) {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscriptionDispatchRate(persistentTopic, rate);
            } else {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscriptionDispatchRate(persistentTopic, this.subName, rate);
            }
        }
    }

    @Parameters(commandDescription="Remove subscription message-dispatch-rate for a topic")
    private class RemoveSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;
        @Parameter(names={"--subscription", "-s"}, description="Remove message-dispatch-rate for a specific subscription")
        private String subName;

        private RemoveSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscriptionDispatchRate.validatePersistentTopic(this.params);
            if (StringUtils.isBlank((CharSequence)this.subName)) {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscriptionDispatchRate(persistentTopic);
            } else {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscriptionDispatchRate(persistentTopic, this.subName);
            }
        }
    }

    @Parameters(commandDescription="Get replicator message-dispatch-rate for a topic")
    private class GetReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetReplicatorDispatchRate.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getReplicatorDispatchRate(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set replicator message-dispatch-rate for a topic")
    private class SetReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)")
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)")
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)")
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))")
        private boolean relativeToPublishRate = false;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicatorDispatchRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setReplicatorDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @Parameters(commandDescription="Remove replicator message-dispatch-rate for a topic")
    private class RemoveReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveReplicatorDispatchRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeReplicatorDispatchRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get publish rate for a topic")
    private class GetPublishRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returns global topic policies")
        private boolean isGlobal = false;

        private GetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPublishRate.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getPublishRate(persistentTopic));
        }
    }

    @Parameters(commandDescription="Set publish rate for a topic")
    private class SetPublishRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-publish-rate", "-m"}, description="message-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgPublishRate = -1;
        @Parameter(names={"--byte-publish-rate", "-b"}, description="byte-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private long bytePublishRate = -1L;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally.")
        private boolean isGlobal = false;

        private SetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPublishRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setPublishRate(persistentTopic, new PublishRate(this.msgPublishRate, this.bytePublishRate));
        }
    }

    @Parameters(commandDescription="Remove publish rate for a topic")
    private class RemovePublishRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. ")
        private boolean isGlobal = false;

        private RemovePublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePublishRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removePublishRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get compaction threshold for a topic")
    private class GetCompactionThreshold
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetCompactionThreshold.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getCompactionThreshold(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set compaction threshold for a topic")
    private class SetCompactionThreshold
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--threshold", "-t"}, description="Maximum number of bytes in a topic backlog before compaction is triggered (eg: 10M, 16G, 3T). 0 disables automatic compaction", required=true)
        private String thresholdStr = "0";
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetCompactionThreshold.validatePersistentTopic(this.params);
            long threshold = SetCompactionThreshold.validateSizeString(this.thresholdStr);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setCompactionThreshold(persistentTopic, threshold);
        }
    }

    @Parameters(commandDescription="Remove compaction threshold for a topic")
    private class RemoveCompactionThreshold
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveCompactionThreshold.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeCompactionThreshold(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get consumer subscribe rate for a topic")
    private class GetSubscribeRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returns global topic policies")
        private boolean isGlobal = false;

        private GetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscribeRate.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscribeRate(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set consumer subscribe rate for a topic")
    private class SetSubscribeRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--subscribe-rate", "-sr"}, description="subscribe-rate (default -1 will be overwrite if not passed)", required=false)
        private int subscribeRate = -1;
        @Parameter(names={"--subscribe-rate-period", "-st"}, description="subscribe-rate-period in second type (default 30 second will be overwrite if not passed)", required=false)
        private int subscribeRatePeriodSec = 30;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally.")
        private boolean isGlobal = false;

        private SetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscribeRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscribeRate(persistentTopic, new SubscribeRate(this.subscribeRate, this.subscribeRatePeriodSec));
        }
    }

    @Parameters(commandDescription="Remove consumer subscribe rate for a topic")
    private class RemoveSubscribeRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. ")
        private boolean isGlobal = false;

        private RemoveSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscribeRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscribeRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max number of consumers for a topic")
    private class GetMaxConsumers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private GetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumers.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxConsumers(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set max number of consumers for a topic")
    private class SetMaxConsumers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-consumers", "-c"}, description="Max consumers for a topic", required=true)
        private int maxConsumers;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumers.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxConsumers(persistentTopic, this.maxConsumers);
        }
    }

    @Parameters(commandDescription="Remove max number of consumers for a topic")
    private class RemoveMaxConsumers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumers.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxConsumers(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the delayed delivery policy for a topic")
    private class GetDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal;

        private GetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topicName = GetDelayedDelivery.validateTopicName(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDelayedDeliveryPolicy(topicName, this.applied));
        }
    }

    @Parameters(commandDescription="Set the delayed delivery policy on a topic")
    private class SetDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable delayed delivery messages")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable delayed delivery messages")
        private boolean disable = false;
        @Parameter(names={"--time", "-t"}, description="The tick time for when retrying on delayed delivery messages, affecting the accuracy of the delivery time compared to the scheduled time. (eg: 1s, 10s, 1m, 5h, 3d)")
        private String delayedDeliveryTimeStr = "1s";
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal;

        private SetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            long delayedDeliveryTimeInMills;
            String topicName = SetDelayedDelivery.validateTopicName(this.params);
            try {
                delayedDeliveryTimeInMills = TimeUnit.SECONDS.toMillis(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.delayedDeliveryTimeStr));
            }
            catch (IllegalArgumentException exception) {
                throw new ParameterException(exception.getMessage());
            }
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDelayedDeliveryPolicy(topicName, DelayedDeliveryPolicies.builder().tickTime(delayedDeliveryTimeInMills).active(this.enable).build());
        }
    }

    @Parameters(commandDescription="Remove the delayed delivery policy on a topic")
    private class RemoveDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal;

        private RemoveDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topicName = RemoveDelayedDelivery.validateTopicName(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDelayedDeliveryPolicy(topicName);
        }
    }

    @Parameters(commandDescription="Get message dispatch rate for a topic")
    private class GetDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDispatchRate.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDispatchRate(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set message dispatch rate for a topic")
    private class SetDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)", required=false)
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))", required=false)
        private boolean relativeToPublishRate = false;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDispatchRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @Parameters(commandDescription="Remove message dispatch rate for a topic")
    private class RemoveDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDispatchRate.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDispatchRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the offload policies for a topic")
    private class GetOffloadPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetOffloadPolicies.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getOffloadPolicies(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set the offload policies for a topic")
    private class SetOffloadPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-d", "--driver"}, description="ManagedLedger offload driver", required=true)
        private String driver;
        @Parameter(names={"-r", "--region"}, description="ManagedLedger offload region, s3 and google-cloud-storage requires this parameter")
        private String region;
        @Parameter(names={"-b", "--bucket"}, description="ManagedLedger offload bucket, s3 and google-cloud-storage requires this parameter")
        private String bucket;
        @Parameter(names={"-e", "--endpoint"}, description="ManagedLedger offload service endpoint, only s3 requires this parameter")
        private String endpoint;
        @Parameter(names={"-i", "--aws-id"}, description="AWS Credential Id to use when using driver S3 or aws-s3")
        private String awsId;
        @Parameter(names={"-s", "--aws-secret"}, description="AWS Credential Secret to use when using driver S3 or aws-s3")
        private String awsSecret;
        @Parameter(names={"--ro", "--s3-role"}, description="S3 Role used for STSAssumeRoleSessionCredentialsProvider")
        private String s3Role;
        @Parameter(names={"--s3-role-session-name", "-rsn"}, description="S3 role session name used for STSAssumeRoleSessionCredentialsProvider")
        private String s3RoleSessionName;
        @Parameter(names={"-m", "--maxBlockSizeInBytes"}, description="ManagedLedger offload max block Size in bytes,s3 and google-cloud-storage requires this parameter")
        private int maxBlockSizeInBytes;
        @Parameter(names={"-rb", "--readBufferSizeInBytes"}, description="ManagedLedger offload read buffer size in bytes,s3 and google-cloud-storage requires this parameter")
        private int readBufferSizeInBytes;
        @Parameter(names={"-t", "--offloadThresholdInBytes"}, description="ManagedLedger offload threshold in bytes", required=true)
        private long offloadThresholdInBytes;
        @Parameter(names={"-ts", "--offloadThresholdInSeconds"}, description="ManagedLedger offload threshold in seconds")
        private Long offloadThresholdInSeconds;
        @Parameter(names={"-dl", "--offloadDeletionLagInMillis"}, description="ManagedLedger offload deletion lag in bytes")
        private Long offloadDeletionLagInMillis;
        @Parameter(names={"--offloadedReadPriority", "-orp"}, description="Read priority for offloaded messages. By default, once messages are offloaded to long-term storage, brokers read messages from long-term storage, but messages can still exist in BookKeeper for a period depends on your configuration. For messages that exist in both long-term storage and BookKeeper, you can set where to read messages from with the option `tiered-storage-first` or `bookkeeper-first`.", required=false)
        private String offloadReadPriorityStr;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetOffloadPolicies.validatePersistentTopic(this.params);
            OffloadedReadPriority offloadedReadPriority = OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY;
            if (this.offloadReadPriorityStr != null) {
                try {
                    offloadedReadPriority = OffloadedReadPriority.fromString((String)this.offloadReadPriorityStr);
                }
                catch (Exception e) {
                    throw new ParameterException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + this.offloadReadPriorityStr, (Throwable)e);
                }
            }
            OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((String)this.driver, (String)this.region, (String)this.bucket, (String)this.endpoint, (String)this.s3Role, (String)this.s3RoleSessionName, (String)this.awsId, (String)this.awsSecret, (Integer)this.maxBlockSizeInBytes, (Integer)this.readBufferSizeInBytes, (Long)this.offloadThresholdInBytes, (Long)this.offloadThresholdInSeconds, (Long)this.offloadDeletionLagInMillis, (OffloadedReadPriority)offloadedReadPriority);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setOffloadPolicies(persistentTopic, (OffloadPolicies)offloadPolicies);
        }
    }

    @Parameters(commandDescription="Remove the offload policies for a topic")
    private class RemoveOffloadPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveOffloadPolicies.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeOffloadPolicies(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max unacked messages policy per subscription for a topic")
    private class GetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private GetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesPerSubscription.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxUnackedMessagesOnSubscription(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set max unacked messages policy on subscription for a topic")
    private class SetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-m", "--maxNum"}, description="max unacked messages num on subscription", required=true)
        private int maxNum;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesPerSubscription.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxUnackedMessagesOnSubscription(persistentTopic, this.maxNum);
        }
    }

    @Parameters(commandDescription="Remove max unacked messages policy per subscription for a topic")
    private class RemoveMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesPerSubscription.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxUnackedMessagesOnSubscription(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the inactive topic policies on a topic")
    private class GetInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInactiveTopicPolicies.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getInactiveTopicPolicies(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set the inactive topic policies on a topic")
    private class SetInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--enable-delete-while-inactive", "-e"}, description="Enable delete while inactive")
        private boolean enableDeleteWhileInactive = false;
        @Parameter(names={"--disable-delete-while-inactive", "-d"}, description="Disable delete while inactive")
        private boolean disableDeleteWhileInactive = false;
        @Parameter(names={"--max-inactive-duration", "-t"}, description="Max duration of topic inactivity in seconds, topics that are inactive for longer than this value will be deleted (eg: 1s, 10s, 1m, 5h, 3d)", required=true)
        private String deleteInactiveTopicsMaxInactiveDuration;
        @Parameter(names={"--delete-mode", "-m"}, description="Mode of delete inactive topic, Valid options are: [delete_when_no_subscriptions, delete_when_subscriptions_caught_up]", required=true)
        private String inactiveTopicDeleteMode;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            InactiveTopicDeleteMode deleteMode;
            long maxInactiveDurationInSeconds;
            String persistentTopic = SetInactiveTopicPolicies.validatePersistentTopic(this.params);
            try {
                maxInactiveDurationInSeconds = TimeUnit.SECONDS.toSeconds(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.deleteInactiveTopicsMaxInactiveDuration));
            }
            catch (IllegalArgumentException exception) {
                throw new ParameterException(exception.getMessage());
            }
            if (this.enableDeleteWhileInactive == this.disableDeleteWhileInactive) {
                throw new ParameterException("Need to specify either enable-delete-while-inactive or disable-delete-while-inactive");
            }
            try {
                deleteMode = InactiveTopicDeleteMode.valueOf((String)this.inactiveTopicDeleteMode);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException("delete mode can only be set to delete_when_no_subscriptions or delete_when_subscriptions_caught_up");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setInactiveTopicPolicies(persistentTopic, new InactiveTopicPolicies(deleteMode, (int)maxInactiveDurationInSeconds, this.enableDeleteWhileInactive));
        }
    }

    @Parameters(commandDescription="Remove inactive topic policies from a topic")
    private class RemoveInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveInactiveTopicPolicies.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeInactiveTopicPolicies(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max subscriptions for a topic")
    private class GetMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxSubscriptionsPerTopic.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxSubscriptionsPerTopic(persistentTopic));
        }
    }

    @Parameters(commandDescription="Set max subscriptions for a topic")
    private class SetMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-subscriptions-per-topic", "-s"}, description="max subscriptions for a topic (default -1 will be overwrite if not passed)", required=true)
        private int maxSubscriptionPerTopic;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxSubscriptionsPerTopic.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxSubscriptionsPerTopic(persistentTopic, this.maxSubscriptionPerTopic);
        }
    }

    @Parameters(commandDescription="Remove max subscriptions for a topic")
    private class RemoveMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxSubscriptionsPerTopic.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxSubscriptionsPerTopic(persistentTopic);
        }
    }

    @Parameters(commandDescription="Remove schema compatibility strategy on a topic")
    private class RemoveSchemaCompatibilityStrategy
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSchemaCompatibilityStrategy.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getAdmin().topicPolicies().removeSchemaCompatibilityStrategy(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set schema compatibility strategy on a topic")
    private class SetSchemaCompatibilityStrategy
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--strategy", "-s"}, description="Schema compatibility strategy: [UNDEFINED, ALWAYS_INCOMPATIBLE, ALWAYS_COMPATIBLE, BACKWARD, FORWARD, FULL, BACKWARD_TRANSITIVE, FORWARD_TRANSITIVE, FULL_TRANSITIVE]", required=true)
        private SchemaCompatibilityStrategy strategy;

        private SetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSchemaCompatibilityStrategy.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getAdmin().topicPolicies().setSchemaCompatibilityStrategy(persistentTopic, this.strategy);
        }
    }

    @Parameters(commandDescription="Get schema compatibility strategy on a topic")
    private class GetSchemaCompatibilityStrategy
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSchemaCompatibilityStrategy.validatePersistentTopic(this.params);
            SchemaCompatibilityStrategy strategy = CmdTopicPolicies.this.getAdmin().topicPolicies().getSchemaCompatibilityStrategy(persistentTopic, this.applied);
            this.print(strategy == null ? "null" : strategy.name());
        }
    }

    @Parameters(commandDescription="Get entry filters for a topic")
    private class GetEntryFiltersPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetEntryFiltersPerTopic.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getEntryFiltersPerTopic(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set entry filters for a topic")
    private class SetEntryFiltersPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--entry-filters-name", "-efn"}, description="The class name for the entry filter.", required=true)
        private String entryFiltersName = "";
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private SetEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetEntryFiltersPerTopic.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setEntryFiltersPerTopic(persistentTopic, new EntryFilters(this.entryFiltersName));
        }
    }

    @Parameters(commandDescription="Remove entry filters for a topic")
    private class RemoveEntryFiltersPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private RemoveEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveEntryFiltersPerTopic.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeEntryFiltersPerTopic(persistentTopic);
        }
    }

    @Parameters(commandDescription="Enable autoSubscriptionCreation for a topic")
    private class SetAutoSubscriptionCreation
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable allowAutoSubscriptionCreation on topic")
        private boolean enable = false;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetAutoSubscriptionCreation.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setAutoSubscriptionCreation(persistentTopic, AutoSubscriptionCreationOverride.builder().allowAutoSubscriptionCreation(this.enable).build());
        }
    }

    @Parameters(commandDescription="Get the autoSubscriptionCreation for a topic")
    private class GetAutoSubscriptionCreation
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--applied", "-a"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetAutoSubscriptionCreation.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getAutoSubscriptionCreation(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove override of autoSubscriptionCreation for a topic")
    private class RemoveAutoSubscriptionCreation
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveAutoSubscriptionCreation.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeAutoSubscriptionCreation(persistentTopic);
        }
    }
}

