/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.secretsprovider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.functions.secretsprovider.SecretsProvider;

public class EnvironmentBasedSecretsProvider
implements SecretsProvider {
    private static final Pattern interpolationPattern = Pattern.compile("\\$\\{(.+?)}");

    @Override
    public String provideSecret(String secretName, Object pathToSecret) {
        return System.getenv(secretName);
    }

    @Override
    public String interpolateSecretForValue(String value) {
        Matcher m = interpolationPattern.matcher(value);
        if (m.matches()) {
            String secretName = m.group(1);
            return this.provideSecret(secretName, null);
        }
        return null;
    }
}

