/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.ModularLoadManagerStrategy;
import org.apache.pulsar.policies.data.loadbalancer.BundleData;

public class RoundRobinBrokerSelector
implements ModularLoadManagerStrategy {
    final AtomicInteger count = new AtomicInteger();
    final AtomicReference<List<String>> ref = new AtomicReference(List.of());

    @Override
    public Optional<String> selectBroker(Set<String> candidates, BundleData bundleToAssign, LoadData loadData, ServiceConfiguration conf) {
        String selected;
        int candidateSize = candidates.size();
        if (candidateSize == 0) {
            return Optional.empty();
        }
        List<String> cache = this.ref.get();
        int cacheSize = cache.size();
        int index = this.count.getAndUpdate(i -> i == Integer.MAX_VALUE ? 0 : i + 1) % candidateSize;
        boolean updateCacheRef = false;
        if (cacheSize <= index || candidateSize != cacheSize) {
            cache = List.copyOf(candidates);
            updateCacheRef = true;
        }
        if (!candidates.contains(selected = cache.get(index))) {
            cache = List.copyOf(candidates);
            updateCacheRef = true;
            selected = cache.get(index);
        }
        if (updateCacheRef) {
            this.ref.set(cache);
        }
        return Optional.of(selected);
    }
}

