/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.shard;

import io.streamnative.oxia.client.shard.Shard;
import io.streamnative.oxia.client.shard.ShardStrategy;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import net.openhft.hashing.LongHashFunction;

class HashRangeShardStrategy
implements ShardStrategy {
    private final Function<String, Long> hashFn;
    static final Function<String, Long> Xxh332Hash = s -> LongHashFunction.xx3().hashBytes(s.getBytes(StandardCharsets.UTF_8)) & 0xFFFFFFFFL;
    static final ShardStrategy Xxh332HashRangeShardStrategy = new HashRangeShardStrategy(Xxh332Hash);

    @Override
    @NonNull
    public Predicate<Shard> acceptsKeyPredicate(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        long hash = this.hashFn.apply(key);
        return shard -> shard.hashRange().minInclusive() <= hash && hash <= shard.hashRange().maxInclusive();
    }

    public HashRangeShardStrategy(Function<String, Long> hashFn) {
        this.hashFn = hashFn;
    }
}

