/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.bookie.LocalBookieEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanityTestCommand
extends BookieCommand<SanityFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(SanityTestCommand.class);
    private static final String NAME = "sanitytest";
    private static final String DESC = "Sanity test for local bookie. Create ledger and write/reads entries on local bookie.";

    public SanityTestCommand() {
        this(new SanityFlags());
    }

    public SanityTestCommand(SanityFlags flags) {
        super(CliSpec.newBuilder().withFlags((CliFlags)flags).withName(NAME).withDescription(DESC).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, SanityFlags cmdFlags) {
        try {
            return SanityTestCommand.handle(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean handle(ServerConfiguration conf, SanityFlags cmdFlags) throws Exception {
        try {
            return SanityTestCommand.handleAsync(conf, cmdFlags).get();
        }
        catch (Exception e) {
            LOG.warn("Error in bookie sanity test", (Throwable)e);
            return false;
        }
    }

    public static CompletableFuture<Boolean> handleAsync(ServerConfiguration conf, SanityFlags cmdFlags) {
        BookKeeper bk;
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.addConfiguration((Configuration)conf);
        clientConf.setEnsemblePlacementPolicy(LocalBookieEnsemblePlacementPolicy.class);
        clientConf.setAddEntryTimeout(cmdFlags.timeout);
        clientConf.setReadEntryTimeout(cmdFlags.timeout);
        try {
            bk = new BookKeeper(clientConf);
        }
        catch (IOException | InterruptedException | BKException e) {
            LOG.warn("Failed to initialize bookkeeper client", (Throwable)e);
            result.completeExceptionally(e);
            return result;
        }
        bk.asyncCreateLedger(1, 1, BookKeeper.DigestType.MAC, new byte[0], (rc, lh, ctx) -> {
            if (rc != 0) {
                LOG.warn("ledger creation failed for sanity command {}", (Object)rc);
                result.completeExceptionally(BKException.create(rc));
                return;
            }
            ArrayList entriesFutures = new ArrayList();
            for (int i = 0; i < cmdFlags.entries; ++i) {
                String content = "entry-" + i;
                CompletableFuture entryFuture = new CompletableFuture();
                entriesFutures.add(entryFuture);
                lh.asyncAddEntry(content.getBytes(StandardCharsets.UTF_8), (arc, alh, entryId, actx) -> {
                    if (arc != 0) {
                        LOG.warn("ledger add entry failed for {}-{}", (Object)alh.getId(), (Object)arc);
                        entryFuture.completeExceptionally(BKException.create(arc));
                        return;
                    }
                    entryFuture.complete(null);
                }, null);
            }
            CompletableFuture lhFuture = new CompletableFuture();
            CompletableFuture readEntryFuture = new CompletableFuture();
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)FutureUtils.collect(entriesFutures).thenCompose(_r -> lh.closeAsync())).thenCompose(_r -> {
                bk.asyncOpenLedger(lh.getId(), BookKeeper.DigestType.MAC, new byte[0], (orc, olh, octx) -> {
                    if (orc != 0) {
                        LOG.warn("open sanity ledger failed for {}-{}", (Object)lh.getId(), (Object)orc);
                        lhFuture.completeExceptionally(BKException.create(orc));
                        return;
                    }
                    long lac = olh.getLastAddConfirmed();
                    if (lac != (long)(cmdFlags.entries - 1)) {
                        lhFuture.completeExceptionally(new Exception("Invalid last entry found on ledger. expecting: " + (cmdFlags.entries - 1) + " -- found: " + lac));
                        return;
                    }
                    lhFuture.complete(lh);
                }, null);
                return lhFuture;
            })).thenCompose(rlh -> {
                rlh.asyncReadEntries(0L, cmdFlags.entries - 1, (rrc, rlh2, entries, rctx) -> {
                    if (rrc != 0) {
                        LOG.warn("reading sanity ledger failed for {}-{}", (Object)lh.getId(), (Object)rrc);
                        readEntryFuture.completeExceptionally(BKException.create(rrc));
                        return;
                    }
                    int i = 0;
                    while (entries.hasMoreElements()) {
                        LedgerEntry entry = (LedgerEntry)entries.nextElement();
                        String actualMsg = new String(entry.getEntry(), StandardCharsets.UTF_8);
                        String expectedMsg = "entry-" + i++;
                        if (expectedMsg.equals(actualMsg)) continue;
                        readEntryFuture.completeExceptionally(new Exception("Failed validation of received message - Expected: " + expectedMsg + ", Actual: " + actualMsg));
                        return;
                    }
                    LOG.info("Read {} entries from ledger {}", (Object)i, (Object)lh.getId());
                    LOG.info("Bookie sanity test succeeded");
                    readEntryFuture.complete(null);
                }, null);
                return readEntryFuture;
            })).thenAccept(_r -> {
                SanityTestCommand.close(bk, lh);
                result.complete(true);
            })).exceptionally(ex -> {
                SanityTestCommand.close(bk, lh);
                result.completeExceptionally(ex.getCause());
                return null;
            });
        }, null);
        return result;
    }

    public static void close(BookKeeper bk, LedgerHandle lh) {
        if (lh != null) {
            bk.asyncDeleteLedger(lh.getId(), (rc, ctx) -> {
                if (rc != 0) {
                    LOG.info("Failed to delete ledger id {}", (Object)lh.getId());
                }
                SanityTestCommand.close(bk);
            }, null);
        } else {
            SanityTestCommand.close(bk);
        }
    }

    private static void close(BookKeeper bk) {
        try {
            bk.close();
        }
        catch (Exception e) {
            LOG.info("Failed to close bookkeeper client {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static class SanityFlags
    extends CliFlags {
        @Parameter(names={"-e", "--entries"}, description="Total entries to be added for the test (default 10)")
        private int entries = 10;
        @Parameter(names={"-t", "--timeout"}, description="Timeout for write/read operations in seconds (default 1)")
        private int timeout = 1;

        public SanityFlags entries(int entries) {
            this.entries = entries;
            return this;
        }

        public SanityFlags timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }
    }
}

