/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.options.OptionsUtil;
import java.util.Objects;
import java.util.Optional;

public final class WatchOption {
    public static final WatchOption DEFAULT = WatchOption.builder().build();
    private final ByteSequence endKey;
    private final long revision;
    private final boolean prevKV;
    private final boolean progressNotify;
    private final boolean createdNotify;
    private final boolean noPut;
    private final boolean noDelete;
    private final boolean requireLeader;
    private final boolean prefix;

    private WatchOption(ByteSequence endKey, long revision, boolean prevKV, boolean progressNotify, boolean createdNotify, boolean noPut, boolean noDelete, boolean requireLeader, boolean prefix) {
        this.endKey = endKey;
        this.revision = revision;
        this.prevKV = prevKV;
        this.progressNotify = progressNotify;
        this.createdNotify = createdNotify;
        this.noPut = noPut;
        this.noDelete = noDelete;
        this.requireLeader = requireLeader;
        this.prefix = prefix;
    }

    public Optional<ByteSequence> getEndKey() {
        return Optional.ofNullable(this.endKey);
    }

    public long getRevision() {
        return this.revision;
    }

    public boolean isPrevKV() {
        return this.prevKV;
    }

    public boolean isProgressNotify() {
        return this.progressNotify;
    }

    public boolean isCreatedNotify() {
        return this.createdNotify;
    }

    public boolean isNoPut() {
        return this.noPut;
    }

    public boolean isNoDelete() {
        return this.noDelete;
    }

    public boolean withRequireLeader() {
        return this.requireLeader;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    @Deprecated
    public static Builder newBuilder() {
        return WatchOption.builder();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private long revision = 0L;
        private ByteSequence endKey;
        private boolean prevKV = false;
        private boolean progressNotify = false;
        private boolean createNotify = false;
        private boolean noPut = false;
        private boolean noDelete = false;
        private boolean requireLeader = false;
        private boolean prefix = false;

        private Builder() {
        }

        public Builder withRevision(long revision) {
            this.revision = revision;
            return this;
        }

        public Builder withRange(ByteSequence endKey) {
            this.endKey = endKey;
            return this;
        }

        public Builder withPrevKV(boolean prevKV) {
            this.prevKV = prevKV;
            return this;
        }

        public Builder withProgressNotify(boolean progressNotify) {
            this.progressNotify = progressNotify;
            return this;
        }

        public Builder withCreateNotify(boolean createNotify) {
            this.createNotify = createNotify;
            return this;
        }

        public Builder withNoPut(boolean noPut) {
            this.noPut = noPut;
            return this;
        }

        public Builder withNoDelete(boolean noDelete) {
            this.noDelete = noDelete;
            return this;
        }

        public Builder isPrefix(boolean prefix) {
            this.prefix = prefix;
            return this;
        }

        @Deprecated
        public Builder withPrefix(ByteSequence prefix) {
            Objects.requireNonNull(prefix, "prefix should not be null");
            ByteSequence prefixEnd = OptionsUtil.prefixEndOf(prefix);
            this.withRange(prefixEnd);
            return this;
        }

        public Builder withRequireLeader(boolean requireLeader) {
            this.requireLeader = requireLeader;
            return this;
        }

        public WatchOption build() {
            return new WatchOption(this.endKey, this.revision, this.prevKV, this.progressNotify, this.createNotify, this.noPut, this.noDelete, this.requireLeader, this.prefix);
        }
    }
}

