/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.EventBus;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.MessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.ReplyException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.BooleanMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.BufferMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.ByteArrayMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.ByteMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.CharMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.ClusterSerializableCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.DoubleMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.FloatMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.IntMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.JsonArrayMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.JsonObjectMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.LongMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.NullMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.PingMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.ReplyExceptionMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.SerializableCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.ShortMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs.StringMessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonArray;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.shareddata.impl.ClusterSerializable;

public class CodecManager {
    public static final MessageCodec<String, String> PING_MESSAGE_CODEC = new PingMessageCodec();
    public static final MessageCodec<String, String> NULL_MESSAGE_CODEC = new NullMessageCodec();
    public static final MessageCodec<String, String> STRING_MESSAGE_CODEC = new StringMessageCodec();
    public static final MessageCodec<Buffer, Buffer> BUFFER_MESSAGE_CODEC = new BufferMessageCodec();
    public static final MessageCodec<JsonObject, JsonObject> JSON_OBJECT_MESSAGE_CODEC = new JsonObjectMessageCodec();
    public static final MessageCodec<JsonArray, JsonArray> JSON_ARRAY_MESSAGE_CODEC = new JsonArrayMessageCodec();
    public static final MessageCodec<byte[], byte[]> BYTE_ARRAY_MESSAGE_CODEC = new ByteArrayMessageCodec();
    public static final MessageCodec<Integer, Integer> INT_MESSAGE_CODEC = new IntMessageCodec();
    public static final MessageCodec<Long, Long> LONG_MESSAGE_CODEC = new LongMessageCodec();
    public static final MessageCodec<Float, Float> FLOAT_MESSAGE_CODEC = new FloatMessageCodec();
    public static final MessageCodec<Double, Double> DOUBLE_MESSAGE_CODEC = new DoubleMessageCodec();
    public static final MessageCodec<Boolean, Boolean> BOOLEAN_MESSAGE_CODEC = new BooleanMessageCodec();
    public static final MessageCodec<Short, Short> SHORT_MESSAGE_CODEC = new ShortMessageCodec();
    public static final MessageCodec<Character, Character> CHAR_MESSAGE_CODEC = new CharMessageCodec();
    public static final MessageCodec<Byte, Byte> BYTE_MESSAGE_CODEC = new ByteMessageCodec();
    public static final MessageCodec<ReplyException, ReplyException> REPLY_EXCEPTION_MESSAGE_CODEC = new ReplyExceptionMessageCodec();
    private final MessageCodec[] systemCodecs;
    private final ConcurrentMap<String, MessageCodec> userCodecMap = new ConcurrentHashMap<String, MessageCodec>();
    private final ConcurrentMap<Class, MessageCodec> defaultCodecMap = new ConcurrentHashMap<Class, MessageCodec>();
    private final ClusterSerializableCodec clusterSerializableCodec = new ClusterSerializableCodec(this);
    private final SerializableCodec serializableCodec = new SerializableCodec(this);
    private volatile Function<String, Boolean> clusterSerializableCheck = s -> Boolean.FALSE;
    private volatile Function<String, Boolean> serializableCheck = EventBus.DEFAULT_SERIALIZABLE_CHECKER;
    private volatile Function<Object, String> codecSelector = o -> null;

    public CodecManager() {
        this.systemCodecs = this.codecs(NULL_MESSAGE_CODEC, PING_MESSAGE_CODEC, STRING_MESSAGE_CODEC, BUFFER_MESSAGE_CODEC, JSON_OBJECT_MESSAGE_CODEC, JSON_ARRAY_MESSAGE_CODEC, BYTE_ARRAY_MESSAGE_CODEC, INT_MESSAGE_CODEC, LONG_MESSAGE_CODEC, FLOAT_MESSAGE_CODEC, DOUBLE_MESSAGE_CODEC, BOOLEAN_MESSAGE_CODEC, SHORT_MESSAGE_CODEC, CHAR_MESSAGE_CODEC, BYTE_MESSAGE_CODEC, REPLY_EXCEPTION_MESSAGE_CODEC, this.clusterSerializableCodec, this.serializableCodec);
    }

    public MessageCodec lookupCodec(Object body, String codecName, boolean local) {
        MessageCodec codec;
        if (codecName != null) {
            codec = this.getCodec(codecName);
        } else if (body == null) {
            codec = NULL_MESSAGE_CODEC;
        } else if (body instanceof String) {
            codec = STRING_MESSAGE_CODEC;
        } else if (body instanceof Buffer) {
            codec = BUFFER_MESSAGE_CODEC;
        } else if (body instanceof JsonObject) {
            codec = JSON_OBJECT_MESSAGE_CODEC;
        } else if (body instanceof JsonArray) {
            codec = JSON_ARRAY_MESSAGE_CODEC;
        } else if (body instanceof byte[]) {
            codec = BYTE_ARRAY_MESSAGE_CODEC;
        } else if (body instanceof Integer) {
            codec = INT_MESSAGE_CODEC;
        } else if (body instanceof Long) {
            codec = LONG_MESSAGE_CODEC;
        } else if (body instanceof Float) {
            codec = FLOAT_MESSAGE_CODEC;
        } else if (body instanceof Double) {
            codec = DOUBLE_MESSAGE_CODEC;
        } else if (body instanceof Boolean) {
            codec = BOOLEAN_MESSAGE_CODEC;
        } else if (body instanceof Short) {
            codec = SHORT_MESSAGE_CODEC;
        } else if (body instanceof Character) {
            codec = CHAR_MESSAGE_CODEC;
        } else if (body instanceof Byte) {
            codec = BYTE_MESSAGE_CODEC;
        } else if (body instanceof ReplyException) {
            codec = (MessageCodec)this.defaultCodecMap.get(body.getClass());
            if (codec == null) {
                codec = REPLY_EXCEPTION_MESSAGE_CODEC;
            }
        } else {
            codec = (MessageCodec)this.defaultCodecMap.get(body.getClass());
            if (codec == null) {
                codecName = this.codecSelector.apply(body);
                if (codecName != null) {
                    codec = this.getCodec(codecName);
                } else if (body instanceof ClusterSerializable && (local || this.acceptClusterSerializable(body.getClass().getName()))) {
                    codec = this.clusterSerializableCodec;
                } else if (body instanceof Serializable && (local || this.acceptSerializable(body.getClass().getName()))) {
                    codec = this.serializableCodec;
                }
            }
        }
        if (codec == null) {
            throw new IllegalArgumentException("No message codec for type: " + body.getClass());
        }
        return codec;
    }

    public MessageCodec getCodec(String codecName) {
        return (MessageCodec)this.userCodecMap.get(codecName);
    }

    public void registerCodec(MessageCodec codec) {
        Objects.requireNonNull(codec, "codec");
        Objects.requireNonNull(codec.name(), "code.name()");
        this.checkSystemCodec(codec);
        if (this.userCodecMap.containsKey(codec.name())) {
            throw new IllegalStateException("Already a codec registered with name " + codec.name());
        }
        this.userCodecMap.put(codec.name(), codec);
    }

    public void unregisterCodec(String name) {
        Objects.requireNonNull(name);
        this.userCodecMap.remove(name);
    }

    public <T> void registerDefaultCodec(Class<T> clazz, MessageCodec<T, ?> codec) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(codec, "codec");
        Objects.requireNonNull(codec.name(), "code.name()");
        this.checkSystemCodec(codec);
        if (this.defaultCodecMap.containsKey(clazz)) {
            throw new IllegalStateException("Already a default codec registered for class " + clazz);
        }
        if (this.userCodecMap.containsKey(codec.name())) {
            throw new IllegalStateException("Already a codec registered with name " + codec.name());
        }
        this.defaultCodecMap.put(clazz, codec);
        this.userCodecMap.put(codec.name(), codec);
    }

    public void unregisterDefaultCodec(Class clazz) {
        Objects.requireNonNull(clazz);
        MessageCodec codec = (MessageCodec)this.defaultCodecMap.remove(clazz);
        if (codec != null) {
            this.userCodecMap.remove(codec.name());
        }
    }

    public MessageCodec[] systemCodecs() {
        return this.systemCodecs;
    }

    private void checkSystemCodec(MessageCodec codec) {
        if (codec.systemCodecID() != -1) {
            throw new IllegalArgumentException("Can't register a system codec");
        }
    }

    private MessageCodec[] codecs(MessageCodec ... codecs) {
        MessageCodec[] arr = new MessageCodec[codecs.length];
        MessageCodec[] messageCodecArray = codecs;
        int n = messageCodecArray.length;
        for (int i = 0; i < n; ++i) {
            MessageCodec codec;
            arr[codec.systemCodecID()] = codec = messageCodecArray[i];
        }
        return arr;
    }

    public void clusterSerializableCheck(Function<String, Boolean> classNamePredicate) {
        this.clusterSerializableCheck = Objects.requireNonNull(classNamePredicate);
    }

    public boolean acceptClusterSerializable(String className) {
        return this.clusterSerializableCheck.apply(className);
    }

    public void serializableCheck(Function<String, Boolean> classNamePredicate) {
        this.serializableCheck = Objects.requireNonNull(classNamePredicate);
    }

    public boolean acceptSerializable(String className) {
        return this.serializableCheck.apply(className);
    }

    public void codecSelector(Function<Object, String> selector) {
        this.codecSelector = Objects.requireNonNull(selector);
    }
}

