/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.api;

import io.oxia.client.api.OptionComparisonType;
import io.oxia.client.api.OptionIncludeValue;
import io.oxia.client.api.OptionPartitionKey;
import io.oxia.client.api.OptionSecondaryIndexName;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GetOption {
    public static final GetOption ComparisonEqual = new OptionComparisonType(OptionComparisonType.ComparisonType.Equal);
    public static final GetOption ComparisonFloor = new OptionComparisonType(OptionComparisonType.ComparisonType.Floor);
    public static final GetOption ComparisonCeiling = new OptionComparisonType(OptionComparisonType.ComparisonType.Ceiling);
    public static final GetOption ComparisonLower = new OptionComparisonType(OptionComparisonType.ComparisonType.Lower);
    public static final GetOption ComparisonHigher = new OptionComparisonType(OptionComparisonType.ComparisonType.Higher);
    public static final GetOption IncludeValue = new OptionIncludeValue(true);
    public static final GetOption ExcludeValue = new OptionIncludeValue(false);

    public static GetOption PartitionKey(@NonNull String partitionKey) {
        if (partitionKey == null) {
            throw new NullPointerException("partitionKey is marked non-null but is null");
        }
        return new OptionPartitionKey(partitionKey);
    }

    public static GetOption IncludeValue(boolean includeValue) {
        return new OptionIncludeValue(includeValue);
    }

    public static GetOption UseIndex(@NonNull String secondaryIndexName) {
        if (secondaryIndexName == null) {
            throw new NullPointerException("secondaryIndexName is marked non-null but is null");
        }
        return new OptionSecondaryIndexName(secondaryIndexName);
    }
}

