/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.cache.caffeine;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.SummaryMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CacheMetricsCollector
extends Collector {
    protected final ConcurrentMap<String, Cache> children = new ConcurrentHashMap<String, Cache>();

    public void addCache(String cacheName, Cache cache) {
        this.children.put(cacheName, cache);
    }

    public void addCache(String cacheName, AsyncCache cache) {
        this.children.put(cacheName, cache.synchronous());
    }

    public Cache removeCache(String cacheName) {
        return (Cache)this.children.remove(cacheName);
    }

    public void clear() {
        this.children.clear();
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        List<String> labelNames = Arrays.asList("cache");
        CounterMetricFamily cacheHitTotal = new CounterMetricFamily("caffeine_cache_hit_total", "Cache hit totals", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheHitTotal);
        CounterMetricFamily cacheMissTotal = new CounterMetricFamily("caffeine_cache_miss_total", "Cache miss totals", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheMissTotal);
        CounterMetricFamily cacheRequestsTotal = new CounterMetricFamily("caffeine_cache_requests_total", "Cache request totals, hits + misses", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheRequestsTotal);
        CounterMetricFamily cacheEvictionTotal = new CounterMetricFamily("caffeine_cache_eviction_total", "Cache eviction totals, doesn't include manually removed entries", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheEvictionTotal);
        GaugeMetricFamily cacheEvictionWeight = new GaugeMetricFamily("caffeine_cache_eviction_weight", "Cache eviction weight", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheEvictionWeight);
        CounterMetricFamily cacheLoadFailure = new CounterMetricFamily("caffeine_cache_load_failure_total", "Cache load failures", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheLoadFailure);
        CounterMetricFamily cacheLoadTotal = new CounterMetricFamily("caffeine_cache_loads_total", "Cache loads: both success and failures", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheLoadTotal);
        GaugeMetricFamily cacheSize = new GaugeMetricFamily("caffeine_cache_estimated_size", "Estimated cache size", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheSize);
        SummaryMetricFamily cacheLoadSummary = new SummaryMetricFamily("caffeine_cache_load_duration_seconds", "Cache load duration: both success and failures", labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheLoadSummary);
        for (Map.Entry c : this.children.entrySet()) {
            List<String> cacheName = Arrays.asList((String)c.getKey());
            CacheStats stats = ((Cache)c.getValue()).stats();
            try {
                cacheEvictionWeight.addMetric(cacheName, (double)stats.evictionWeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
            cacheHitTotal.addMetric(cacheName, (double)stats.hitCount());
            cacheMissTotal.addMetric(cacheName, (double)stats.missCount());
            cacheRequestsTotal.addMetric(cacheName, (double)stats.requestCount());
            cacheEvictionTotal.addMetric(cacheName, (double)stats.evictionCount());
            cacheSize.addMetric(cacheName, (double)((Cache)c.getValue()).estimatedSize());
            if (!(c.getValue() instanceof LoadingCache)) continue;
            cacheLoadFailure.addMetric(cacheName, (double)stats.loadFailureCount());
            cacheLoadTotal.addMetric(cacheName, (double)stats.loadCount());
            cacheLoadSummary.addMetric(cacheName, (double)stats.loadCount(), (double)stats.totalLoadTime() / 1.0E9);
        }
        return mfs;
    }
}

