/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.limiter;

import com.google.common.base.Preconditions;
import org.apache.distributedlog.limiter.RateLimiter;

public class GuavaRateLimiter
implements RateLimiter {
    com.google.common.util.concurrent.RateLimiter limiter;

    public static RateLimiter of(int limit) {
        if (limit == 0) {
            return RateLimiter.REJECT;
        }
        if (limit < 0) {
            return RateLimiter.ACCEPT;
        }
        return new GuavaRateLimiter(limit);
    }

    public GuavaRateLimiter(int limit) {
        double effectiveLimit = limit;
        if (limit < 0) {
            effectiveLimit = Double.POSITIVE_INFINITY;
        }
        this.limiter = com.google.common.util.concurrent.RateLimiter.create((double)effectiveLimit);
    }

    @Override
    public boolean acquire(int permits) {
        Preconditions.checkState((permits >= 0 ? 1 : 0) != 0);
        if (permits > 0) {
            return this.limiter.tryAcquire(permits);
        }
        return true;
    }
}

