/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core;

import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.CacheReturn;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.Fluent;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.GenIgnore;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.Nullable;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.VertxGen;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Context;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.DeploymentOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.TimeoutStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Timer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Verticle;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxBuilder;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.WorkerExecutor;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.datagram.DatagramSocket;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.datagram.DatagramSocketOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.dns.DnsClient;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.dns.DnsClientOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.EventBus;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.file.FileSystem;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClient;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientBuilder;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServerOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.PoolOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.WebSocketClient;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.WebSocketClientOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.metrics.Measured;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.metrics.MetricsOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetClient;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetClientOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetServer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetServerOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.shareddata.SharedData;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.VerticleFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.VertxMetricsFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.VertxTracerFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.cluster.ClusterManager;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.tracing.TracingOptions;

@VertxGen
public interface Vertx
extends Measured {
    public static VertxBuilder builder() {
        return new VertxBuilder(){
            VertxOptions options;
            VertxTracerFactory tracerFactory;
            VertxMetricsFactory metricsFactory;
            ClusterManager clusterManager;

            @Override
            public VertxBuilder with(VertxOptions options) {
                this.options = options;
                return this;
            }

            @Override
            public VertxBuilder withTracer(VertxTracerFactory factory) {
                this.tracerFactory = factory;
                return this;
            }

            @Override
            public VertxBuilder withClusterManager(ClusterManager clusterManager) {
                this.clusterManager = clusterManager;
                return this;
            }

            @Override
            public VertxBuilder withMetrics(VertxMetricsFactory factory) {
                this.metricsFactory = factory;
                return this;
            }

            private org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxBuilder internalBuilder() {
                VertxOptions opts;
                VertxOptions vertxOptions = opts = this.options != null ? this.options : new VertxOptions();
                if (this.clusterManager != null) {
                    opts.setClusterManager(this.clusterManager);
                }
                if (this.metricsFactory != null) {
                    MetricsOptions metricsOptions = opts.getMetricsOptions();
                    if (metricsOptions != null) {
                        metricsOptions.setFactory(this.metricsFactory);
                    } else {
                        opts.setMetricsOptions(new MetricsOptions().setFactory(this.metricsFactory));
                    }
                    metricsOptions.setEnabled(true);
                }
                if (this.tracerFactory != null) {
                    TracingOptions tracingOptions = opts.getTracingOptions();
                    if (tracingOptions != null) {
                        tracingOptions.setFactory(this.tracerFactory);
                    } else {
                        opts.setTracingOptions(new TracingOptions().setFactory(this.tracerFactory));
                    }
                }
                return new org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxBuilder(opts).init();
            }

            @Override
            public Vertx build() {
                return this.internalBuilder().vertx();
            }

            @Override
            public Future<Vertx> buildClustered() {
                return Future.future(p -> this.internalBuilder().clusteredVertx((Handler<AsyncResult<Vertx>>)p));
            }
        };
    }

    public static Vertx vertx() {
        return Vertx.vertx(new VertxOptions());
    }

    public static Vertx vertx(VertxOptions options) {
        return Vertx.builder().with(options).build();
    }

    public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        Future<Vertx> fut = Vertx.clusteredVertx(options);
        fut.onComplete(resultHandler);
    }

    public static Future<Vertx> clusteredVertx(VertxOptions options) {
        return Vertx.builder().with(options).buildClustered();
    }

    public static @Nullable Context currentContext() {
        return VertxImpl.currentContext(Thread.currentThread());
    }

    public Context getOrCreateContext();

    public NetServer createNetServer(NetServerOptions var1);

    default public NetServer createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    public NetClient createNetClient(NetClientOptions var1);

    default public NetClient createNetClient() {
        return this.createNetClient(new NetClientOptions());
    }

    public HttpServer createHttpServer(HttpServerOptions var1);

    default public HttpServer createHttpServer() {
        return this.createHttpServer(new HttpServerOptions());
    }

    default public WebSocketClient createWebSocketClient() {
        return this.createWebSocketClient(new WebSocketClientOptions());
    }

    public WebSocketClient createWebSocketClient(WebSocketClientOptions var1);

    public HttpClientBuilder httpClientBuilder();

    default public HttpClient createHttpClient(HttpClientOptions clientOptions, PoolOptions poolOptions) {
        return this.httpClientBuilder().with(clientOptions).with(poolOptions).build();
    }

    default public HttpClient createHttpClient(HttpClientOptions clientOptions) {
        return this.createHttpClient(clientOptions, clientOptions.getPoolOptions());
    }

    default public HttpClient createHttpClient(PoolOptions poolOptions) {
        return this.createHttpClient(new HttpClientOptions(), poolOptions);
    }

    default public HttpClient createHttpClient() {
        return this.createHttpClient(new HttpClientOptions(), new PoolOptions());
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions var1);

    default public DatagramSocket createDatagramSocket() {
        return this.createDatagramSocket(new DatagramSocketOptions());
    }

    @CacheReturn
    public FileSystem fileSystem();

    @CacheReturn
    public EventBus eventBus();

    public DnsClient createDnsClient(int var1, String var2);

    public DnsClient createDnsClient();

    public DnsClient createDnsClient(DnsClientOptions var1);

    @CacheReturn
    public SharedData sharedData();

    default public Timer timer(long delay) {
        return this.timer(delay, TimeUnit.MILLISECONDS);
    }

    public Timer timer(long var1, TimeUnit var3);

    public long setTimer(long var1, Handler<Long> var3);

    @Deprecated
    public TimeoutStream timerStream(long var1);

    default public long setPeriodic(long delay, Handler<Long> handler) {
        return this.setPeriodic(delay, delay, handler);
    }

    public long setPeriodic(long var1, long var3, Handler<Long> var5);

    @Deprecated
    default public TimeoutStream periodicStream(long delay) {
        return this.periodicStream(0L, delay);
    }

    @Deprecated
    public TimeoutStream periodicStream(long var1, long var3);

    public boolean cancelTimer(long var1);

    public void runOnContext(Handler<Void> var1);

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    @GenIgnore(value={"permitted-type"})
    default public Future<String> deployVerticle(Verticle verticle) {
        return this.deployVerticle(verticle, new DeploymentOptions());
    }

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, Handler<AsyncResult<String>> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<String> deployVerticle(Verticle var1, DeploymentOptions var2);

    @GenIgnore
    public Future<String> deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public Future<String> deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore
    public void deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    default public Future<String> deployVerticle(String name) {
        return this.deployVerticle(name, new DeploymentOptions());
    }

    default public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(name, new DeploymentOptions(), completionHandler);
    }

    public Future<String> deployVerticle(String var1, DeploymentOptions var2);

    public void deployVerticle(String var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    public Future<Void> undeploy(String var1);

    public void undeploy(String var1, Handler<AsyncResult<Void>> var2);

    public Set<String> deploymentIDs();

    @GenIgnore(value={"permitted-type"})
    public void registerVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public void unregisterVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public Set<VerticleFactory> verticleFactories();

    public boolean isClustered();

    @Deprecated
    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<@Nullable T>> resultHandler) {
        Context context = this.getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, ordered, resultHandler);
    }

    @Deprecated
    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<@Nullable T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    @Deprecated
    default public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        Context context = this.getOrCreateContext();
        return context.executeBlocking(blockingCodeHandler, ordered);
    }

    @GenIgnore(value={"permitted-type"})
    default public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        Context context = this.getOrCreateContext();
        return context.executeBlocking(blockingCodeHandler, ordered);
    }

    @GenIgnore(value={"permitted-type"})
    default public <T> void executeBlocking(Callable<T> blockingCodeHandler, Handler<AsyncResult<@Nullable T>> resultHandler) {
        Future<T> future = this.executeBlocking(blockingCodeHandler, true);
        if (resultHandler != null) {
            future.onComplete(resultHandler);
        }
    }

    @GenIgnore(value={"permitted-type"})
    default public <T> void executeBlocking(Callable<T> blockingCodeHandler, boolean ordered, Handler<AsyncResult<@Nullable T>> resultHandler) {
        Future<T> future = this.executeBlocking(blockingCodeHandler, ordered);
        if (resultHandler != null) {
            future.onComplete(resultHandler);
        }
    }

    @Deprecated
    default public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    @GenIgnore(value={"permitted-type"})
    default public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    @GenIgnore(value={"permitted-type"})
    @Deprecated
    public EventLoopGroup nettyEventLoopGroup();

    public WorkerExecutor createSharedWorkerExecutor(String var1);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    @CacheReturn
    public boolean isNativeTransportEnabled();

    @CacheReturn
    public Throwable unavailableNativeTransportCause();

    @Fluent
    public Vertx exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();
}

