/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogExceptionRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LogExceptionRunnable.class);
    private final Runnable task;

    public LogExceptionRunnable(Runnable task) {
        this.task = (Runnable)Preconditions.checkNotNull((Object)task);
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Throwable t) {
            log.error("Exception while executing runnable " + this.task, t);
            Throwables.throwIfUnchecked((Throwable)t);
            throw new AssertionError((Object)t);
        }
    }

    public String toString() {
        return "LogExceptionRunnable(" + this.task + ")";
    }
}

