/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.lock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.lock.LockClosedException;
import org.apache.distributedlog.lock.SessionLockFactory;
import org.apache.distributedlog.lock.ZKDistributedLock;
import org.apache.distributedlog.lock.ZKSessionLock;
import org.apache.distributedlog.lock.ZKSessionLockFactory;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistributedLock
extends TestDistributedLogBase {
    private static final Logger logger = LoggerFactory.getLogger(TestDistributedLock.class);
    @Rule
    public TestName runtime = new TestName();
    private static final int sessionTimeoutMs = 2000;
    private ZooKeeperClient zkc;
    private ZooKeeperClient zkc0;
    private OrderedScheduler lockStateExecutor;

    @Override
    @Before
    public void setup() throws Exception {
        this.zkc = ZooKeeperClientBuilder.newBuilder().name("zkc").uri(this.createDLMURI("/")).sessionTimeoutMs(2000).zkAclId(null).build();
        this.zkc0 = ZooKeeperClientBuilder.newBuilder().name("zkc0").uri(this.createDLMURI("/")).sessionTimeoutMs(2000).zkAclId(null).build();
        this.lockStateExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-scheduer").numThreads(1).build();
    }

    @Override
    @After
    public void teardown() throws Exception {
        this.zkc.close();
        this.zkc0.close();
        this.lockStateExecutor.shutdown();
    }

    private static void createLockPath(ZooKeeper zk, String lockPath) throws Exception {
        zk.create(lockPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    private static List<String> getLockWaiters(ZooKeeperClient zkc, String lockPath) throws Exception {
        List children = zkc.get().getChildren(lockPath, false);
        Collections.sort(children, ZKSessionLock.MEMBER_COMPARATOR);
        return children;
    }

    private SessionLockFactory createLockFactory(String clientId, ZooKeeperClient zkc) {
        return this.createLockFactory(clientId, zkc, Long.MAX_VALUE, 0);
    }

    private SessionLockFactory createLockFactory(String clientId, ZooKeeperClient zkc, long lockTimeoutMs, int recreationTimes) {
        return new ZKSessionLockFactory(zkc, clientId, this.lockStateExecutor, recreationTimes, lockTimeoutMs, 2000L, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    private static void checkLockAndReacquire(ZKDistributedLock lock, boolean sync) throws Exception {
        lock.checkOwnershipAndReacquire();
        CompletableFuture reacquireFuture = lock.getLockReacquireFuture();
        if (null != reacquireFuture && sync) {
            Utils.ioResult((CompletableFuture)reacquireFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testZooKeeperConnectionLossOnLockCreation() throws Exception {
        ZKDistributedLock lock2;
        String lockPath = "/test-zookeeper-connection-loss-on-lock-creation-" + System.currentTimeMillis();
        String clientId = "zookeeper-connection-loss";
        TestDistributedLock.createLockPath(this.zkc.get(), lockPath);
        FailpointUtils.setFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_ZooKeeperConnectionLoss, (FailpointUtils.FailPointAction)new CountDownThrowFailPointAction(0, Integer.MAX_VALUE));
        SessionLockFactory lockFactory = this.createLockFactory(clientId, this.zkc, Long.MAX_VALUE, 0);
        try {
            try {
                lock2 = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
                Utils.ioResult((CompletableFuture)lock2.asyncAcquire());
                Assert.fail((String)"Should fail on creating lock if couldn't establishing connections to zookeeper");
            }
            catch (IOException lock2) {
                // empty catch block
            }
        }
        finally {
            FailpointUtils.removeFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_ZooKeeperConnectionLoss);
        }
        FailpointUtils.setFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_ZooKeeperConnectionLoss, (FailpointUtils.FailPointAction)new CountDownThrowFailPointAction(0, Integer.MAX_VALUE));
        lockFactory = this.createLockFactory(clientId, this.zkc, Long.MAX_VALUE, 3);
        try {
            try {
                lock2 = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
                Utils.ioResult((CompletableFuture)lock2.asyncAcquire());
                Assert.fail((String)"Should fail on creating lock if couldn't establishing connections to zookeeper after 3 retries");
            }
            catch (IOException lock3) {
                // empty catch block
            }
        }
        finally {
            FailpointUtils.removeFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_ZooKeeperConnectionLoss);
        }
        FailpointUtils.setFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_ZooKeeperConnectionLoss, (FailpointUtils.FailPointAction)new CountDownThrowFailPointAction(0, 3));
        lockFactory = this.createLockFactory(clientId, this.zkc, Long.MAX_VALUE, 5);
        try {
            lock2 = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
            Utils.ioResult((CompletableFuture)lock2.asyncAcquire());
            Pair lockId1 = ((ZKSessionLock)lock2.getInternalLock()).getLockId();
            List<String> children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
            Assert.assertEquals((long)1L, (long)children.size());
            Assert.assertTrue((boolean)lock2.haveLock());
            Assert.assertEquals((Object)lockId1, (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc0.get(), (String)lockPath, (String)children.get(0))));
            lock2.asyncClose();
        }
        finally {
            FailpointUtils.removeFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_ZooKeeperConnectionLoss);
        }
    }

    @Test(timeout=60000L)
    public void testBasicAcquireRelease() throws Exception {
        String lockPath = "/test-basic-acquire-release-" + System.currentTimeMillis();
        String clientId = "basic-acquire-release";
        TestDistributedLock.createLockPath(this.zkc.get(), lockPath);
        SessionLockFactory lockFactory = this.createLockFactory(clientId, this.zkc);
        ZKDistributedLock lock = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock.asyncAcquire());
        Pair lockId1 = ((ZKSessionLock)lock.getInternalLock()).getLockId();
        List<String> children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((boolean)lock.haveLock());
        Assert.assertEquals((Object)lockId1, (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc0.get(), (String)lockPath, (String)children.get(0))));
        Utils.ioResult((CompletableFuture)lock.asyncClose());
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
        Assert.assertFalse((boolean)lock.haveLock());
        lock = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock.asyncAcquire());
        Pair lockId2 = ((ZKSessionLock)lock.getInternalLock()).getLockId();
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((boolean)lock.haveLock());
        Assert.assertEquals((Object)lockId2, (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc0.get(), (String)lockPath, (String)children.get(0))));
        Assert.assertEquals((Object)lockId1, (Object)lockId2);
        Utils.ioResult((CompletableFuture)lock.asyncClose());
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
        Assert.assertFalse((boolean)lock.haveLock());
        try {
            Utils.ioResult((CompletableFuture)lock.asyncAcquire());
            Assert.fail((String)"Should fail on acquiring a closed lock");
        }
        catch (UnexpectedException unexpectedException) {
            // empty catch block
        }
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
        Assert.assertFalse((boolean)lock.haveLock());
    }

    @Test(timeout=60000L)
    public void testCheckWriteLockFailureWhenLockIsAcquiredByOthers() throws Exception {
        String lockPath = "/test-check-write-lock-failure-when-lock-is-acquired-by-others-" + System.currentTimeMillis();
        String clientId = "test-check-write-lock-failure";
        TestDistributedLock.createLockPath(this.zkc.get(), lockPath);
        SessionLockFactory lockFactory0 = this.createLockFactory(clientId, this.zkc0);
        ZKDistributedLock lock0 = new ZKDistributedLock(this.lockStateExecutor, lockFactory0, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock0.asyncAcquire());
        Pair lockId0_1 = ((ZKSessionLock)lock0.getInternalLock()).getLockId();
        List<String> children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((boolean)lock0.haveLock());
        Assert.assertEquals((Object)lockId0_1, (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc0.get(), (String)lockPath, (String)children.get(0))));
        ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        TestDistributedLock.checkLockAndReacquire(lock0, true);
        Pair lockId0_2 = ((ZKSessionLock)lock0.getInternalLock()).getLockId();
        Assert.assertFalse((String)"New lock should be created under different session", (boolean)lockId0_1.equals((Object)lockId0_2));
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((boolean)lock0.haveLock());
        Assert.assertEquals((Object)lockId0_2, (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc0.get(), (String)lockPath, (String)children.get(0))));
        SessionLockFactory lockFactory = this.createLockFactory(clientId, this.zkc);
        final ZKDistributedLock lock1 = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        final CountDownLatch lockLatch = new CountDownLatch(1);
        Thread lockThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.ioResult((CompletableFuture)lock1.asyncAcquire());
                    lockLatch.countDown();
                }
                catch (Exception e) {
                    logger.error("Failed on locking lock1 : ", (Throwable)e);
                }
            }
        }, "lock-thread");
        lockThread.start();
        do {
            Thread.sleep(1L);
        } while ((children = TestDistributedLock.getLockWaiters(this.zkc, lockPath)).size() < 2);
        ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        lockLatch.await();
        lockThread.join();
        try {
            TestDistributedLock.checkLockAndReacquire(lock0, true);
            Assert.fail((String)"Should fail on checking write lock since lock is acquired by lock1");
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
        try {
            TestDistributedLock.checkLockAndReacquire(lock0, false);
            Assert.fail((String)"Should fail on checking write lock since lock is acquired by lock1");
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testLockReacquireSuccessAfterCheckWriteLock() throws Exception {
        this.testLockReacquireSuccess(true);
    }

    @Test(timeout=60000L)
    public void testLockReacquireSuccessWithoutCheckWriteLock() throws Exception {
        this.testLockReacquireSuccess(false);
    }

    private void testLockReacquireSuccess(boolean checkOwnershipAndReacquire) throws Exception {
        String lockPath = "/test-lock-re-acquire-success-" + checkOwnershipAndReacquire + "-" + System.currentTimeMillis();
        String clientId = "test-lock-re-acquire";
        TestDistributedLock.createLockPath(this.zkc.get(), lockPath);
        SessionLockFactory lockFactory0 = this.createLockFactory(clientId, this.zkc0);
        ZKDistributedLock lock0 = new ZKDistributedLock(this.lockStateExecutor, lockFactory0, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock0.asyncAcquire());
        Pair lockId0_1 = ((ZKSessionLock)lock0.getInternalLock()).getLockId();
        List<String> children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((boolean)lock0.haveLock());
        Assert.assertEquals((Object)lockId0_1, (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc0.get(), (String)lockPath, (String)children.get(0))));
        ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        if (checkOwnershipAndReacquire) {
            TestDistributedLock.checkLockAndReacquire(lock0, true);
            TestDistributedLock.checkLockAndReacquire(lock0, false);
        } else {
            CompletableFuture asyncLockAcquireFuture;
            do {
                Thread.sleep(1L);
            } while (null == (asyncLockAcquireFuture = lock0.getLockReacquireFuture()) && lock0.getReacquireCount() < 1);
            if (null != asyncLockAcquireFuture) {
                Utils.ioResult((CompletableFuture)asyncLockAcquireFuture);
            }
            TestDistributedLock.checkLockAndReacquire(lock0, false);
        }
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((boolean)lock0.haveLock());
        Pair lock0_2 = ((ZKSessionLock)lock0.getInternalLock()).getLockId();
        Assert.assertEquals((Object)lock0_2, (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc.get(), (String)lockPath, (String)children.get(0))));
        Assert.assertEquals((Object)clientId, (Object)lock0_2.getLeft());
        Assert.assertFalse((boolean)lockId0_1.equals((Object)lock0_2));
        Utils.ioResult((CompletableFuture)lock0.asyncClose());
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
    }

    @Test(timeout=60000L)
    public void testLockReacquireFailureAfterCheckWriteLock() throws Exception {
        this.testLockReacquireFailure(true);
    }

    @Test(timeout=60000L)
    public void testLockReacquireFailureWithoutCheckWriteLock() throws Exception {
        this.testLockReacquireFailure(false);
    }

    private void testLockReacquireFailure(boolean checkOwnershipAndReacquire) throws Exception {
        List<String> children;
        String lockPath = "/test-lock-re-acquire-failure-" + checkOwnershipAndReacquire + "-" + System.currentTimeMillis();
        String clientId = "test-lock-re-acquire";
        TestDistributedLock.createLockPath(this.zkc.get(), lockPath);
        SessionLockFactory lockFactory0 = this.createLockFactory(clientId, this.zkc0);
        ZKDistributedLock lock0 = new ZKDistributedLock(this.lockStateExecutor, lockFactory0, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock0.asyncAcquire());
        final CountDownLatch lock1DoneLatch = new CountDownLatch(1);
        SessionLockFactory lockFactory1 = this.createLockFactory(clientId, this.zkc);
        final ZKDistributedLock lock1 = new ZKDistributedLock(this.lockStateExecutor, lockFactory1, lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        Thread lock1Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.ioResult((CompletableFuture)lock1.asyncAcquire());
                    lock1DoneLatch.countDown();
                }
                catch (Exception e) {
                    logger.error("Error on acquiring lock1 : ", (Throwable)e);
                }
            }
        }, "lock1-thread");
        lock1Thread.start();
        do {
            Thread.sleep(1L);
        } while ((children = TestDistributedLock.getLockWaiters(this.zkc, lockPath)).size() < 2);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertTrue((boolean)lock0.haveLock());
        Assert.assertFalse((boolean)lock1.haveLock());
        Assert.assertEquals((Object)((ZKSessionLock)lock0.getInternalLock()).getLockId(), (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc0.get(), (String)lockPath, (String)children.get(0))));
        Assert.assertEquals((Object)((ZKSessionLock)lock1.getInternalLock()).getLockId(), (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc.get(), (String)lockPath, (String)children.get(1))));
        logger.info("Expiring session on lock0");
        ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        logger.info("Session on lock0 is expired");
        lock1DoneLatch.await();
        Assert.assertFalse((boolean)lock0.haveLock());
        Assert.assertTrue((boolean)lock1.haveLock());
        if (checkOwnershipAndReacquire) {
            try {
                TestDistributedLock.checkLockAndReacquire(lock0, true);
                Assert.fail((String)"Should fail check write lock since lock is already held by other people");
            }
            catch (OwnershipAcquireFailedException oafe) {
                Assert.assertEquals((Object)((ZKSessionLock)lock1.getInternalLock()).getLockId().getLeft(), (Object)oafe.getCurrentOwner());
            }
            try {
                TestDistributedLock.checkLockAndReacquire(lock0, false);
                Assert.fail((String)"Should fail check write lock since lock is already held by other people");
            }
            catch (OwnershipAcquireFailedException oafe) {
                Assert.assertEquals((Object)((ZKSessionLock)lock1.getInternalLock()).getLockId().getLeft(), (Object)oafe.getCurrentOwner());
            }
        } else {
            CompletableFuture asyncLockAcquireFuture;
            logger.info("Waiting lock0 to attempt acquisition after session expired");
            do {
                Thread.sleep(1L);
            } while (null == (asyncLockAcquireFuture = lock0.getLockReacquireFuture()));
            try {
                Utils.ioResult((CompletableFuture)asyncLockAcquireFuture);
                Assert.fail((String)"Should fail check write lock since lock is already held by other people");
            }
            catch (OwnershipAcquireFailedException oafe) {
                Assert.assertEquals((Object)((ZKSessionLock)lock1.getInternalLock()).getLockId().getLeft(), (Object)oafe.getCurrentOwner());
            }
            try {
                TestDistributedLock.checkLockAndReacquire(lock0, false);
                Assert.fail((String)"Should fail check write lock since lock is already held by other people");
            }
            catch (OwnershipAcquireFailedException oafe) {
                Assert.assertEquals((Object)((ZKSessionLock)lock1.getInternalLock()).getLockId().getLeft(), (Object)oafe.getCurrentOwner());
            }
        }
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertFalse((boolean)lock0.haveLock());
        Assert.assertTrue((boolean)lock1.haveLock());
        Assert.assertEquals((Object)((ZKSessionLock)lock1.getInternalLock()).getLockId(), (Object)Utils.ioResult((CompletableFuture)ZKSessionLock.asyncParseClientID((ZooKeeper)this.zkc.get(), (String)lockPath, (String)children.get(0))));
        Utils.ioResult((CompletableFuture)lock0.asyncClose());
        Utils.ioResult((CompletableFuture)lock1.asyncClose());
        children = TestDistributedLock.getLockWaiters(this.zkc, lockPath);
        Assert.assertEquals((long)0L, (long)children.size());
    }

    @Test(timeout=60000L)
    public void testLockReacquire() throws Exception {
        String lockPath = "/reacquirePath";
        Utils.zkCreateFullPathOptimistic((ZooKeeperClient)this.zkc, (String)lockPath, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        String clientId = "lockHolder";
        SessionLockFactory lockFactory = this.createLockFactory(clientId, this.zkc, conf.getLockTimeoutMilliSeconds(), 0);
        ZKDistributedLock lock = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, conf.getLockTimeoutMilliSeconds(), (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock.asyncAcquire());
        lock.getInternalLock().unlock();
        TestDistributedLock.checkLockAndReacquire(lock, true);
        Assert.assertEquals((Object)true, (Object)lock.haveLock());
        Assert.assertEquals((Object)true, (Object)lock.getInternalLock().isLockHeld());
        lockFactory = this.createLockFactory(clientId + "_2", this.zkc, conf.getLockTimeoutMilliSeconds(), 0);
        ZKDistributedLock lock2 = new ZKDistributedLock(this.lockStateExecutor, lockFactory, lockPath, 0L, (StatsLogger)NullStatsLogger.INSTANCE);
        boolean exceptionEncountered = false;
        try {
            Utils.ioResult((CompletableFuture)lock2.asyncAcquire());
        }
        catch (OwnershipAcquireFailedException exc) {
            Assert.assertEquals((Object)clientId, (Object)exc.getCurrentOwner());
            exceptionEncountered = true;
        }
        Assert.assertTrue((boolean)exceptionEncountered);
        Utils.ioResult((CompletableFuture)lock.asyncClose());
        Utils.ioResult((CompletableFuture)lock2.asyncClose());
    }

    @Test(timeout=60000L)
    public void testLockReacquireMultiple() throws Exception {
        String lockPath = "/reacquirePathMultiple";
        Utils.zkCreateFullPathOptimistic((ZooKeeperClient)this.zkc, (String)lockPath, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        String clientId = "lockHolder";
        SessionLockFactory factory = this.createLockFactory(clientId, this.zkc, conf.getLockTimeoutMilliSeconds(), 0);
        ZKDistributedLock lock = new ZKDistributedLock(this.lockStateExecutor, factory, lockPath, conf.getLockTimeoutMilliSeconds(), (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock.asyncAcquire());
        lock.getInternalLock().unlock();
        TestDistributedLock.checkLockAndReacquire(lock, true);
        Assert.assertEquals((Object)true, (Object)lock.haveLock());
        Assert.assertEquals((Object)true, (Object)lock.getInternalLock().isLockHeld());
        factory = this.createLockFactory(clientId + "_2", this.zkc, 0L, 0);
        ZKDistributedLock lock2 = new ZKDistributedLock(this.lockStateExecutor, factory, lockPath, 0L, (StatsLogger)NullStatsLogger.INSTANCE);
        boolean exceptionEncountered = false;
        try {
            Utils.ioResult((CompletableFuture)lock2.asyncAcquire());
        }
        catch (OwnershipAcquireFailedException exc) {
            Assert.assertEquals((Object)clientId, (Object)exc.getCurrentOwner());
            exceptionEncountered = true;
        }
        Assert.assertTrue((boolean)exceptionEncountered);
        Utils.ioResult((CompletableFuture)lock2.asyncClose());
        Utils.ioResult((CompletableFuture)lock.asyncClose());
        Assert.assertEquals((Object)false, (Object)lock.haveLock());
        Assert.assertEquals((Object)false, (Object)lock.getInternalLock().isLockHeld());
        factory = this.createLockFactory(clientId + "_3", this.zkc, 0L, 0);
        ZKDistributedLock lock3 = new ZKDistributedLock(this.lockStateExecutor, factory, lockPath, 0L, (StatsLogger)NullStatsLogger.INSTANCE);
        Utils.ioResult((CompletableFuture)lock3.asyncAcquire());
        Assert.assertEquals((Object)true, (Object)lock3.haveLock());
        Assert.assertEquals((Object)true, (Object)lock3.getInternalLock().isLockHeld());
        Utils.ioResult((CompletableFuture)lock3.asyncClose());
    }

    void assertLatchesSet(CountDownLatch[] latches, int endIndex) {
        int i;
        for (i = 0; i < endIndex; ++i) {
            Assert.assertEquals((String)("latch " + i + " should have been set"), (long)0L, (long)latches[i].getCount());
        }
        for (i = endIndex; i < latches.length; ++i) {
            Assert.assertEquals((String)("latch " + i + " should not have been set"), (long)1L, (long)latches[i].getCount());
        }
    }

    void assertLockState(ZKDistributedLock lock0, boolean owned0, boolean intOwned0, ZKDistributedLock lock1, boolean owned1, boolean intOwned1, int waiters, String lockPath) throws Exception {
        Assert.assertEquals((Object)owned0, (Object)lock0.haveLock());
        Assert.assertEquals((Object)intOwned0, (Object)(lock0.getInternalLock() != null && lock0.getInternalLock().isLockHeld() ? 1 : 0));
        Assert.assertEquals((Object)owned1, (Object)lock1.haveLock());
        Assert.assertEquals((Object)intOwned1, (Object)(lock1.getInternalLock() != null && lock1.getInternalLock().isLockHeld() ? 1 : 0));
        Assert.assertEquals((long)waiters, (long)TestDistributedLock.getLockWaiters(this.zkc, lockPath).size());
    }

    @Test(timeout=60000L)
    public void testAsyncAcquireBasics() throws Exception {
        int i;
        TestLockFactory locks = new TestLockFactory(this.runtime.getMethodName(), this.zkc, this.lockStateExecutor);
        int count = 3;
        ArrayList<CompletionStage> results = new ArrayList<CompletionStage>(count);
        ZKDistributedLock[] lockArray = new ZKDistributedLock[count];
        final CountDownLatch[] latches = new CountDownLatch[count];
        for (i = 0; i < count; ++i) {
            latches[i] = new CountDownLatch(1);
            lockArray[i] = locks.createLock(i, this.zkc);
            final int index = i;
            results.add(lockArray[i].asyncAcquire().whenComplete((BiConsumer)new FutureEventListener<ZKDistributedLock>(){

                public void onSuccess(ZKDistributedLock lock) {
                    latches[index].countDown();
                }

                public void onFailure(Throwable cause) {
                    Assert.fail((String)("unexpected failure " + cause));
                }
            }));
        }
        for (i = 0; i < count; ++i) {
            latches[i].await();
            this.assertLatchesSet(latches, i + 1);
            Utils.ioResult((CompletableFuture)((CompletableFuture)results.get(i)));
            Utils.ioResult((CompletableFuture)lockArray[i].asyncClose());
        }
    }

    @Test(timeout=60000L)
    public void testAsyncAcquireSyncThenAsyncOnSameLock() throws Exception {
        TestLockFactory locks = new TestLockFactory(this.runtime.getMethodName(), this.zkc, this.lockStateExecutor);
        ZKDistributedLock lock0 = locks.createLock(0, this.zkc);
        final ZKDistributedLock lock1 = locks.createLock(1, this.zkc0);
        Utils.ioResult((CompletableFuture)lock0.asyncAcquire());
        this.assertLockState(lock0, true, true, lock1, false, false, 1, locks.getLockPath());
        Thread lock1Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.ioResult((CompletableFuture)lock1.asyncAcquire());
                }
                catch (Exception e) {
                    Assert.fail((String)"shouldn't fail to acquire");
                }
            }
        }, "lock1-thread");
        lock1Thread.start();
        while (TestDistributedLock.getLockWaiters(this.zkc, locks.getLockPath()).size() < 2) {
            Thread.sleep(1L);
        }
        this.assertLockState(lock0, true, true, lock1, false, false, 2, locks.getLockPath());
        Utils.ioResult((CompletableFuture)lock0.asyncClose());
        Utils.ioResult((CompletableFuture)lock1.getLockAcquireFuture());
        this.assertLockState(lock0, false, false, lock1, true, true, 1, locks.getLockPath());
        Utils.ioResult((CompletableFuture)lock1.asyncClose());
        this.assertLockState(lock0, false, false, lock1, false, false, 0, locks.getLockPath());
    }

    @Test(timeout=60000L)
    public void testAsyncAcquireExpireDuringWait() throws Exception {
        TestLockFactory locks = new TestLockFactory(this.runtime.getMethodName(), this.zkc, this.lockStateExecutor);
        ZKDistributedLock lock0 = locks.createLock(0, this.zkc);
        ZKDistributedLock lock1 = locks.createLock(1, this.zkc0);
        Utils.ioResult((CompletableFuture)lock0.asyncAcquire());
        CompletableFuture result = lock1.asyncAcquire();
        while (null == lock1.getLockWaiter()) {
            TimeUnit.MILLISECONDS.sleep(20L);
        }
        ZooKeeperClientUtils.expireSession(this.zkc0, zkServers, 2000);
        try {
            Utils.ioResult((CompletableFuture)result);
            Assert.fail((String)"future should have been failed");
        }
        catch (OwnershipAcquireFailedException ownershipAcquireFailedException) {
            // empty catch block
        }
        this.assertLockState(lock0, true, true, lock1, false, false, 1, locks.getLockPath());
        lock0.asyncClose();
        lock1.asyncClose();
    }

    @Test(timeout=60000L)
    public void testAsyncAcquireCloseDuringWait() throws Exception {
        TestLockFactory locks = new TestLockFactory(this.runtime.getMethodName(), this.zkc, this.lockStateExecutor);
        ZKDistributedLock lock0 = locks.createLock(0, this.zkc);
        ZKDistributedLock lock1 = locks.createLock(1, this.zkc0);
        Utils.ioResult((CompletableFuture)lock0.asyncAcquire());
        CompletableFuture result = lock1.asyncAcquire();
        Utils.ioResult((CompletableFuture)lock1.asyncClose());
        try {
            Utils.ioResult((CompletableFuture)result);
            Assert.fail((String)"future should have been failed");
        }
        catch (LockClosedException lockClosedException) {
            // empty catch block
        }
        this.assertLockState(lock0, true, true, lock1, false, false, 1, locks.getLockPath());
        lock0.asyncClose();
    }

    @Test(timeout=60000L)
    public void testAsyncAcquireCloseAfterAcquire() throws Exception {
        TestLockFactory locks = new TestLockFactory(this.runtime.getMethodName(), this.zkc, this.lockStateExecutor);
        ZKDistributedLock lock0 = locks.createLock(0, this.zkc);
        CompletableFuture result = lock0.asyncAcquire();
        Utils.ioResult((CompletableFuture)result);
        Utils.ioResult((CompletableFuture)lock0.asyncClose());
        Utils.ioResult((CompletableFuture)result);
        Assert.assertEquals((Object)false, (Object)lock0.haveLock());
        Assert.assertEquals((Object)false, (Object)lock0.getInternalLock().isLockHeld());
    }

    static class CountDownThrowFailPointAction
    extends FailpointUtils.AbstractFailPointAction {
        final AtomicInteger successCounter;
        final AtomicInteger failureCounter;

        CountDownThrowFailPointAction(int successCount, int failureCount) {
            this.successCounter = new AtomicInteger(successCount);
            this.failureCounter = new AtomicInteger(failureCount);
        }

        public boolean checkFailPoint() throws IOException {
            int successCount = this.successCounter.getAndDecrement();
            if (successCount > 0) {
                return true;
            }
            int count = this.failureCounter.getAndDecrement();
            if (count > 0) {
                throw new IOException("counter = " + count);
            }
            return true;
        }
    }

    static class TestLockFactory {
        final String lockPath;
        final String clientId;
        final OrderedScheduler lockStateExecutor;

        public TestLockFactory(String name, ZooKeeperClient defaultZkc, OrderedScheduler lockStateExecutor) throws Exception {
            this.lockPath = "/" + name + System.currentTimeMillis();
            this.clientId = name;
            TestDistributedLock.createLockPath(defaultZkc.get(), this.lockPath);
            this.lockStateExecutor = lockStateExecutor;
        }

        public ZKDistributedLock createLock(int id, ZooKeeperClient zkc) throws Exception {
            ZKSessionLockFactory lockFactory = new ZKSessionLockFactory(zkc, this.clientId + id, this.lockStateExecutor, 0, Long.MAX_VALUE, 2000L, (StatsLogger)NullStatsLogger.INSTANCE);
            return new ZKDistributedLock(this.lockStateExecutor, (SessionLockFactory)lockFactory, this.lockPath, Long.MAX_VALUE, (StatsLogger)NullStatsLogger.INSTANCE);
        }

        public String getLockPath() {
            return this.lockPath;
        }
    }
}

