/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus;

import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.CacheReturn;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.Nullable;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.VertxGen;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.MultiMap;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.DeliveryOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.ReplyException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.ReplyFailure;

@VertxGen
public interface Message<T> {
    public String address();

    public MultiMap headers();

    @CacheReturn
    public T body();

    public @Nullable String replyAddress();

    public boolean isSend();

    default public void reply(@Nullable Object message) {
        this.reply(message, new DeliveryOptions());
    }

    public void reply(@Nullable Object var1, DeliveryOptions var2);

    default public <R> void replyAndRequest(@Nullable Object message, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.replyAndRequest(message, new DeliveryOptions(), replyHandler);
    }

    default public <R> Future<Message<R>> replyAndRequest(@Nullable Object message) {
        return this.replyAndRequest(message, new DeliveryOptions());
    }

    default public <R> void replyAndRequest(@Nullable Object message, DeliveryOptions options, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.replyAndRequest(message, options).onComplete(replyHandler);
    }

    public <R> Future<Message<R>> replyAndRequest(@Nullable Object var1, DeliveryOptions var2);

    default public void fail(int failureCode, String message) {
        this.reply(new ReplyException(ReplyFailure.RECIPIENT_FAILURE, failureCode, message));
    }
}

