/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Internal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public final class InternalCheckGcpEnvironment {
    private static final Logger logger = Logger.getLogger(InternalCheckGcpEnvironment.class.getName());
    private static final String WINDOWS_COMMAND = "powershell.exe";
    private static Boolean cachedResult = null;

    private InternalCheckGcpEnvironment() {
    }

    public static synchronized boolean isOnGcp() {
        if (cachedResult == null) {
            cachedResult = InternalCheckGcpEnvironment.isRunningOnGcp();
        }
        return cachedResult;
    }

    @VisibleForTesting
    static boolean checkProductNameOnLinux(BufferedReader reader) throws IOException {
        String name = reader.readLine().trim();
        return name.equals("Google") || name.equals("Google Compute Engine");
    }

    @VisibleForTesting
    static boolean checkBiosDataOnWindows(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("Manufacturer")) continue;
            String name = line.substring(line.indexOf(58) + 1).trim();
            return name.equals("Google");
        }
        return false;
    }

    private static boolean isRunningOnGcp() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        try {
            if (osName.startsWith("linux")) {
                return InternalCheckGcpEnvironment.checkProductNameOnLinux(Files.newBufferedReader(Paths.get("/sys/class/dmi/id/product_name", new String[0]), StandardCharsets.UTF_8));
            }
            if (osName.startsWith("windows")) {
                Process p = new ProcessBuilder(new String[0]).command(WINDOWS_COMMAND, "Get-WmiObject", "-Class", "Win32_BIOS").start();
                return InternalCheckGcpEnvironment.checkBiosDataOnWindows(new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8)));
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Fail to read platform information: ", e);
            return false;
        }
        return false;
    }
}

