# PIP-279: Support topic-level policies using TableView API

# Motivation

reformat property,for a http header name cannot contain the following prohibited characters: =,;: \t\r\n\v\f

for example:
{"city=shanghai":"tag"}
when we run `bin/pulsar-admin topics get-message-by-id `, it will throw exception, the exception is:
`Reason: java.util.concurrent.CompletionException: org.apache.pulsar.client.admin.internal.http.AsyncHttpConnector$RetryException: Could not complete the operation. Number of retries has been exhausted. Failed reason: a header name cannot contain the following prohibited characters: =,;: \t\r\n\v\f: =`

# High Level Design

In master branch,
in an http request:getMessageById("/{tenant}/{namespace}/{topic}/ledger/{ledgerId}/entry/{entryId}"),
replace `"X-Pulsar-PROPERTY-" + msgProperties.getKey()` with `"X-Pulsar-PROPERTY"`

After release-3.1.0, this feature begins to take effect.

# Concrete Example

for example, the current message's properties likes this:
```
"name": "James"
"gender": "man"
"details=man": "good at playing basketball"
```

## BEFORE
old response header format:
```
headers: {
  "X-Pulsar-PROPERTY-name": "James",
  "X-Pulsar-PROPERTY-gender": "man",
  "X-Pulsar-PROPERTY-details=man": "good at playing basketball"
}
```
but it will throw exception in the end check

## AFTER
new response header format:
```
headers: {
"X-Pulsar-PROPERTY": '{"name": "James", "gender": "man", "details=man": "good at playing basketball"}'
}
```

# Links

<!--
Updated afterwards
-->
* Mailing List discussion thread: https://lists.apache.org/thread/vfc99mbj2z2xgwfs1hq1zxrow13qm2n7
* Mailing List voting thread: https://lists.apache.org/thread/g354684m9h495o3p0kmzb7fh7vfxhddx
