/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class QueueDeclareOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 11;
    private final AMQShortString _queue;
    private final long _messageCount;
    private final long _consumerCount;

    public QueueDeclareOkBody(AMQShortString queue, long messageCount, long consumerCount) {
        this._queue = queue;
        this._messageCount = messageCount;
        this._consumerCount = consumerCount;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    public final long getConsumerCount() {
        return this._consumerCount;
    }

    @Override
    protected int getBodySize() {
        int size = 8;
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._queue);
        this.writeUnsignedInteger(buffer, this._messageCount);
        this.writeUnsignedInteger(buffer, this._consumerCount);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueDeclareOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeclareOkBodyImpl: ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append(", ");
        buf.append("consumerCount=");
        buf.append(this.getConsumerCount());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ClientChannelMethodProcessor dispatcher) {
        AMQShortString queue = AMQShortString.readAMQShortString(buffer);
        long messageCount = buffer.getUnsignedInt();
        long consumerCount = buffer.getUnsignedInt();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueDeclareOk(queue, messageCount, consumerCount);
        }
    }
}

