/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.lang.reflect.Array;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ListConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.MapConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.NullTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.ZeroListConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public abstract class AbstractCompositeTypeConstructor<T>
implements DescribedTypeConstructor<T> {
    @Override
    public TypeConstructor<T> construct(Object descriptor, QpidByteBuffer in, int originalPosition, ValueHandler valueHandler) throws AmqpErrorException {
        return new FieldValueReader();
    }

    protected abstract String getTypeName();

    protected abstract T construct(FieldValueReader var1) throws AmqpErrorException;

    protected class FieldValueReader
    implements TypeConstructor<T> {
        private QpidByteBuffer _in;
        private ValueHandler _valueHandler;
        private int _count;

        protected FieldValueReader() {
        }

        @Override
        public T construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
            this._in = in;
            this._valueHandler = handler;
            return this.constructType();
        }

        private T constructType() throws AmqpErrorException {
            int size;
            TypeConstructor typeConstructor = this._valueHandler.readConstructor(this._in);
            long remaining = this._in.remaining();
            if (typeConstructor instanceof ListConstructor) {
                ListConstructor listConstructor = (ListConstructor)typeConstructor;
                if (remaining < (long)(listConstructor.getSize() * 2)) {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Not sufficient data for deserialization of '%s'. Expected at least %d bytes. Got %d bytes.", AbstractCompositeTypeConstructor.this.getTypeName(), listConstructor.getSize(), remaining), new Object[0]);
                }
                if (listConstructor.getSize() == 1) {
                    size = this._in.getUnsignedByte();
                    this._count = this._in.getUnsignedByte();
                } else {
                    size = this._in.getInt();
                    this._count = this._in.getInt();
                }
                if ((remaining -= (long)listConstructor.getSize()) < (long)size) {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Not sufficient data for deserialization of '%s'. Expected at least %d bytes. Got %d bytes.", AbstractCompositeTypeConstructor.this.getTypeName(), size, remaining), new Object[0]);
                }
            } else if (typeConstructor instanceof ZeroListConstructor) {
                size = 0;
                this._count = 0;
            } else {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Unexpected format when deserializing of '%s'", AbstractCompositeTypeConstructor.this.getTypeName()), new Object[0]);
            }
            Object constructedObject = AbstractCompositeTypeConstructor.this.construct(this);
            long expectedRemaining = remaining - (long)size;
            long unconsumedBytes = (long)this._in.remaining() - expectedRemaining;
            if (unconsumedBytes > 0L) {
                String msg = String.format("%s incorrectly encoded, %d bytes remaining after decoding %d elements", AbstractCompositeTypeConstructor.this.getTypeName(), unconsumedBytes, this._count);
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, msg, new Object[0]);
            }
            if (unconsumedBytes < 0L) {
                String msg = String.format("%s incorrectly encoded, %d bytes beyond provided size consumed after decoding %d elements", AbstractCompositeTypeConstructor.this.getTypeName(), -unconsumedBytes, this._count);
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, msg, new Object[0]);
            }
            return constructedObject;
        }

        public <F> F readValue(int fieldIndex, String fieldName, boolean mandatory, Class<F> expectedType) throws AmqpErrorException {
            if (fieldIndex >= this._count) {
                if (mandatory) {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Mandatory field '%s' of '%s' was not provided", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()), new Object[0]);
                }
                return null;
            }
            Object value = this._valueHandler.parse(this._in);
            if (value == null && mandatory) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Mandatory field '%s' of '%s' was not provided", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()), new Object[0]);
            }
            if (value != null && !expectedType.isAssignableFrom(value.getClass())) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Wrong type for field '%s' of '%s'. Expected '%s' but got '%s'.", fieldName, AbstractCompositeTypeConstructor.this.getTypeName(), expectedType.getSimpleName(), value.getClass().getSimpleName()), new Object[0]);
            }
            return (F)value;
        }

        public <K, V> Map<K, V> readMapValue(int fieldIndex, String fieldName, boolean mandatory, Class<K> expectedKeyType, Class<V> expectedValueType) throws AmqpErrorException {
            if (fieldIndex >= this._count) {
                if (mandatory) {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Mandatory field '%s' of '%s' was not provided", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()), new Object[0]);
                }
                return null;
            }
            TypeConstructor typeConstructor = this._valueHandler.readConstructor(this._in);
            if (typeConstructor instanceof MapConstructor) {
                MapConstructor mapConstructor = (MapConstructor)typeConstructor;
                return mapConstructor.construct(this._in, this._valueHandler, expectedKeyType, expectedValueType);
            }
            if (typeConstructor instanceof NullTypeConstructor) {
                if (mandatory) {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Mandatory field '%s' of '%s' was not provided", fieldName, AbstractCompositeTypeConstructor.this.getTypeName());
                }
            } else {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Could not decode value field '%s' of '%s'", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()), new Object[0]);
            }
            return null;
        }

        public <F> F[] readArrayValue(int fieldIndex, String fieldName, boolean mandatory, Class<F> expectedType, Converter<F> converter) throws AmqpErrorException {
            if (fieldIndex >= this._count) {
                if (mandatory) {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Mandatory field '%s' of '%s' was not provided", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()), new Object[0]);
                }
                return null;
            }
            Object value = this._valueHandler.parse(this._in);
            if (mandatory && value == null) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Mandatory field '%s' of '%s' was not provided", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()), new Object[0]);
            }
            if (value != null) {
                if (value.getClass().isArray()) {
                    if (expectedType.isAssignableFrom(value.getClass().getComponentType())) {
                        return (Object[])value;
                    }
                    Object[] objects = (Object[])value;
                    Object[] array = (Object[])Array.newInstance(expectedType, objects.length);
                    try {
                        for (int i = 0; i < objects.length; ++i) {
                            array[i] = converter.convert(objects[i]);
                        }
                    }
                    catch (RuntimeException e) {
                        Error error = new Error(AmqpError.DECODE_ERROR, String.format("Could not decode value field '%s' of '%s'", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()));
                        throw new AmqpErrorException(error, (Throwable)e);
                    }
                    return array;
                }
                if (expectedType.isAssignableFrom(value.getClass())) {
                    Object[] array = (Object[])Array.newInstance(expectedType, 1);
                    array[0] = value;
                    return array;
                }
                try {
                    F convertedValue = converter.convert(value);
                    Object[] array = (Object[])Array.newInstance(expectedType, 1);
                    array[0] = convertedValue;
                    return array;
                }
                catch (RuntimeException e) {
                    Error error = new Error(AmqpError.DECODE_ERROR, String.format("Could not decode value field '%s' of '%s'", fieldName, AbstractCompositeTypeConstructor.this.getTypeName()));
                    throw new AmqpErrorException(error, (Throwable)e);
                }
            }
            return null;
        }
    }

    public static interface Converter<T> {
        public T convert(Object var1) throws AmqpErrorException;
    }
}

