/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;

public abstract class Model {
    <X extends ConfiguredObject<X>> Collection<X> getReachableObjects(ConfiguredObject<?> object, Class<X> clazz) {
        ConfiguredObject ancestor;
        Class<? extends ConfiguredObject> category = ConfiguredObjectTypeRegistry.getCategory(object.getClass());
        Class<? extends ConfiguredObject> ancestorClass = this.getAncestorClassWithGivenDescendant(category, clazz);
        if (ancestorClass != null && (ancestor = this.getAncestor(ancestorClass, category, object)) != null) {
            return this.getAllDescendants(ancestor, ancestorClass, clazz);
        }
        return null;
    }

    <X extends ConfiguredObject<X>> Collection<X> getAllDescendants(ConfiguredObject ancestor, Class<? extends ConfiguredObject> ancestorClass, Class<X> clazz) {
        HashSet descendants = new HashSet();
        for (Class<? extends ConfiguredObject> childClass : this.getChildTypes(ancestorClass)) {
            Collection<? extends ConfiguredObject> children = ancestor.getChildren(childClass);
            if (childClass == clazz) {
                if (children == null) continue;
                descendants.addAll(children);
                continue;
            }
            if (children == null) continue;
            for (ConfiguredObject configuredObject : children) {
                descendants.addAll(this.getAllDescendants(configuredObject, childClass, clazz));
            }
        }
        return descendants;
    }

    public <C> C getAncestor(Class<C> ancestorClass, ConfiguredObject<?> object) {
        return this.getAncestor(ancestorClass, object.getCategoryClass(), object);
    }

    public <C> C getAncestor(Class<C> ancestorClass, Class<? extends ConfiguredObject> category, ConfiguredObject<?> object) {
        ConfiguredObject<?> parent;
        C ancestor;
        if (ancestorClass.isInstance(object)) {
            return (C)object;
        }
        Class<? extends ConfiguredObject> parentClass = this.getParentType(category);
        if (parentClass != null && (ancestor = this.getAncestor(ancestorClass, parentClass, parent = object.getParent())) != null) {
            return ancestor;
        }
        return null;
    }

    public Class<? extends ConfiguredObject> getAncestorClassWithGivenDescendant(Class<? extends ConfiguredObject> category, Class<? extends ConfiguredObject> descendantClass) {
        Set<Class<? extends ConfiguredObject>> candidateClasses = Collections.singleton(category);
        while (!candidateClasses.isEmpty()) {
            for (Class clazz : candidateClasses) {
                if (!this.hasDescendant(clazz, descendantClass)) continue;
                return clazz;
            }
            HashSet<Class<? extends ConfiguredObject>> previous = new HashSet<Class<? extends ConfiguredObject>>(candidateClasses);
            candidateClasses = new HashSet<Class<? extends ConfiguredObject>>();
            for (Class clazz : previous) {
                Class<? extends ConfiguredObject> parentType = this.getParentType(clazz);
                if (parentType == null) continue;
                candidateClasses.add(parentType);
            }
        }
        return null;
    }

    private boolean hasDescendant(Class<? extends ConfiguredObject> candidate, Class<? extends ConfiguredObject> descendantClass) {
        int oldSize = 0;
        HashSet<Class<? extends ConfiguredObject>> allDescendants = new HashSet<Class<? extends ConfiguredObject>>(this.getChildTypes(candidate));
        while (allDescendants.size() > oldSize) {
            oldSize = allDescendants.size();
            HashSet<Class<? extends ConfiguredObject>> prev = new HashSet<Class<? extends ConfiguredObject>>(allDescendants);
            for (Class clazz : prev) {
                allDescendants.addAll(this.getChildTypes(clazz));
            }
            if (!allDescendants.contains(descendantClass)) continue;
            break;
        }
        return allDescendants.contains(descendantClass);
    }

    public final Collection<Class<? extends ConfiguredObject>> getDescendantCategories(Class<? extends ConfiguredObject> parent) {
        HashSet<Class<? extends ConfiguredObject>> allDescendants = new HashSet<Class<? extends ConfiguredObject>>();
        for (Class<? extends ConfiguredObject> clazz : this.getChildTypes(parent)) {
            if (!allDescendants.add(clazz)) continue;
            allDescendants.addAll(this.getDescendantCategories(clazz));
        }
        return allDescendants;
    }

    public final Collection<Class<? extends ConfiguredObject>> getAncestorCategories(Class<? extends ConfiguredObject> category) {
        HashSet<Class<? extends ConfiguredObject>> allAncestors = new HashSet<Class<? extends ConfiguredObject>>();
        Class<? extends ConfiguredObject> clazz = this.getParentType(category);
        if (clazz != null && allAncestors.add(clazz)) {
            allAncestors.addAll(this.getAncestorCategories(clazz));
        }
        return allAncestors;
    }

    public abstract Collection<Class<? extends ConfiguredObject>> getSupportedCategories();

    public abstract Collection<Class<? extends ConfiguredObject>> getChildTypes(Class<? extends ConfiguredObject> var1);

    public abstract Class<? extends ConfiguredObject> getRootCategory();

    public abstract Class<? extends ConfiguredObject> getParentType(Class<? extends ConfiguredObject> var1);

    public abstract int getMajorVersion();

    public abstract int getMinorVersion();

    public abstract ConfiguredObjectFactory getObjectFactory();

    public abstract ConfiguredObjectTypeRegistry getTypeRegistry();

    public static boolean isSpecialization(Model model, Model specialization, Class<? extends ConfiguredObject> specializationPoint) {
        if (model.getSupportedCategories().contains(specializationPoint) && specialization.getSupportedCategories().containsAll(model.getSupportedCategories()) && model.getChildTypes(specializationPoint).isEmpty()) {
            ArrayList<Class<? extends ConfiguredObject>> modelSupportedCategories = new ArrayList<Class<? extends ConfiguredObject>>(model.getSupportedCategories());
            modelSupportedCategories.remove(specializationPoint);
            for (Class clazz : modelSupportedCategories) {
                if (model.getChildTypes(clazz).equals(specialization.getChildTypes(clazz))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

