/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Iterator;
import java.util.Map;
import org.apache.qpid.server.queue.AbstractQueue;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public abstract class OutOfOrderQueue<X extends OutOfOrderQueue<X>>
extends AbstractQueue<X> {
    OutOfOrderQueue(Map<String, Object> attributes, QueueManagingVirtualHost<?> virtualHost) {
        super(attributes, virtualHost);
    }

    @Override
    protected void checkConsumersNotAheadOfDelivery(QueueEntry entry) {
        Iterator<QueueConsumer<?, ?>> consumerIterator = this.getQueueConsumerManager().getAllIterator();
        while (consumerIterator.hasNext() && !entry.isAcquired()) {
            QueueContext context;
            QueueConsumer<?, ?> consumer = consumerIterator.next();
            if (consumer.isClosed() || (context = consumer.getQueueContext()) == null) continue;
            QueueEntry released = context.getReleasedEntry();
            while (!(entry.isAcquired() || released != null && released.compareTo(entry) <= 0 || QueueContext._releasedUpdater.compareAndSet(context, released, entry))) {
                released = context.getReleasedEntry();
            }
        }
    }
}

