/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.futures;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientSynchronization;

public class BalancedClientFuture<V>
extends ClientFuture<V> {
    private static final int SPIN_COUNT = 10;
    private static final int YIELD_COUNT = 100;

    public BalancedClientFuture() {
        this(null);
    }

    public BalancedClientFuture(ClientSynchronization<V> synchronization) {
        super(synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long amount, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isNotComplete() && amount > 0L) {
            long timeout = unit.toNanos(amount);
            long startTime = System.nanoTime();
            int idleCount = 0;
            while (this.isNotComplete()) {
                long elapsed = System.nanoTime() - startTime;
                long diff = elapsed - timeout;
                if (diff >= 0L) {
                    throw new TimeoutException("Timed out waiting for completion");
                }
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                BalancedClientFuture balancedClientFuture = this;
                synchronized (balancedClientFuture) {
                    if (this.isComplete()) {
                        break;
                    }
                    if (this.getState() < 1) {
                        ++this.waiting;
                        try {
                            this.wait(-diff / 1000000L, (int)(-diff % 1000000L));
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            throw e;
                        }
                        finally {
                            --this.waiting;
                        }
                    }
                }
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.isNotComplete()) {
            int idleCount = 0;
            while (this.isNotComplete()) {
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                BalancedClientFuture balancedClientFuture = this;
                synchronized (balancedClientFuture) {
                    if (this.isComplete()) {
                        break;
                    }
                    if (this.getState() < 1) {
                        ++this.waiting;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            throw e;
                        }
                        finally {
                            --this.waiting;
                        }
                    }
                }
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.getResult();
    }
}

