/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;

public interface ProtonBufferAccessors {
    public byte peekByte();

    public byte getByte(int var1);

    public ProtonBuffer setByte(int var1, byte var2);

    public byte readByte();

    public ProtonBuffer writeByte(byte var1);

    default public boolean getBoolean(int index) {
        return this.getByte(index) != 0;
    }

    default public ProtonBuffer setBoolean(int index, boolean value) {
        return this.setByte(index, (byte)(value ? 1 : 0));
    }

    default public boolean readBoolean() {
        return this.readByte() != 0;
    }

    default public ProtonBuffer writeBoolean(boolean value) {
        return this.writeByte((byte)(value ? 1 : 0));
    }

    default public int getUnsignedByte(int index) {
        return this.getByte(index) & 0xFF;
    }

    default public ProtonBuffer setUnsignedByte(int index, int value) {
        return this.setByte(index, (byte)(value & 0xFF));
    }

    default public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    default public ProtonBuffer writeUnsignedByte(int value) {
        return this.writeByte((byte)(value & 0xFF));
    }

    public char getChar(int var1);

    public ProtonBuffer setChar(int var1, char var2);

    public char readChar();

    public ProtonBuffer writeChar(char var1);

    public short getShort(int var1);

    public ProtonBuffer setShort(int var1, short var2);

    public short readShort();

    public ProtonBuffer writeShort(short var1);

    default public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    default public ProtonBuffer setUnsignedShort(int index, int value) {
        return this.setShort(index, (short)(value & 0xFFFF));
    }

    default public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    default public ProtonBuffer writeUnsignedShort(int value) {
        return this.writeShort((short)(value & 0xFFFF));
    }

    public int getInt(int var1);

    public ProtonBuffer setInt(int var1, int var2);

    public int readInt();

    public ProtonBuffer writeInt(int var1);

    default public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    default public ProtonBuffer setUnsignedInt(int index, long value) {
        return this.setInt(index, (int)(value & 0xFFFFFFFFL));
    }

    default public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    default public ProtonBuffer writeUnsignedInt(long value) {
        return this.writeInt((int)(value & 0xFFFFFFFFL));
    }

    public long getLong(int var1);

    public ProtonBuffer setLong(int var1, long var2);

    public long readLong();

    public ProtonBuffer writeLong(long var1);

    default public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    default public ProtonBuffer setFloat(int index, float value) {
        return this.setInt(index, Float.floatToIntBits(value));
    }

    default public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    default public ProtonBuffer writeFloat(float value) {
        return this.writeInt(Float.floatToIntBits(value));
    }

    default public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    default public ProtonBuffer setDouble(int index, double value) {
        return this.setLong(index, Double.doubleToLongBits(value));
    }

    default public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    default public ProtonBuffer writeDouble(double value) {
        return this.writeLong(Double.doubleToLongBits(value));
    }
}

