/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.EngineHandler;
import org.apache.qpid.protonj2.engine.EngineHandlerContext;
import org.apache.qpid.protonj2.engine.HeaderEnvelope;
import org.apache.qpid.protonj2.engine.IncomingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.SASLEnvelope;
import org.apache.qpid.protonj2.engine.util.StringUtils;
import org.apache.qpid.protonj2.logging.ProtonLogger;
import org.apache.qpid.protonj2.logging.ProtonLoggerFactory;

public class ProtonFrameLoggingHandler
implements EngineHandler {
    private static final ProtonLogger LOG = ProtonLoggerFactory.getLogger(ProtonFrameLoggingHandler.class);
    private static final String AMQP_IN_PREFIX = "<- AMQP";
    private static final String AMQP_OUT_PREFIX = "-> AMQP";
    private static final String SASL_IN_PREFIX = "<- SASL";
    private static final String SASL_OUT_PREFIX = "-> SASL";
    private static final int PAYLOAD_STRING_LIMIT = 64;
    private static final String PN_TRACE_FRM = "PN_TRACE_FRM";
    private static final boolean TRACE_FRM_ENABLED = ProtonFrameLoggingHandler.checkTraceFramesEnabled();
    private boolean traceFrames = TRACE_FRM_ENABLED;
    private int uniqueIdentifier;

    private static final boolean checkTraceFramesEnabled() {
        String value = System.getenv(PN_TRACE_FRM);
        return "true".equalsIgnoreCase(value) || "1".equals(value) || "yes".equalsIgnoreCase(value);
    }

    void setTraceFrames(boolean traceFrames) {
        this.traceFrames = traceFrames;
    }

    boolean isTraceFrames() {
        return this.traceFrames;
    }

    @Override
    public void handlerAdded(EngineHandlerContext context) {
        this.uniqueIdentifier = System.identityHashCode(context.engine());
    }

    @Override
    public void handleRead(EngineHandlerContext context, HeaderEnvelope envelope) {
        if (this.traceFrames) {
            ProtonFrameLoggingHandler.trace(envelope.isSaslHeader() ? SASL_IN_PREFIX : AMQP_IN_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), null);
        }
        ProtonFrameLoggingHandler.log(envelope.isSaslHeader() ? SASL_IN_PREFIX : AMQP_IN_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), null);
        context.fireRead(envelope);
    }

    @Override
    public void handleRead(EngineHandlerContext context, SASLEnvelope envelope) {
        if (this.traceFrames) {
            ProtonFrameLoggingHandler.trace(SASL_IN_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), null);
        }
        ProtonFrameLoggingHandler.log(SASL_IN_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), envelope.getPayload());
        context.fireRead(envelope);
    }

    @Override
    public void handleRead(EngineHandlerContext context, IncomingAMQPEnvelope envelope) {
        if (this.traceFrames) {
            ProtonFrameLoggingHandler.trace(AMQP_IN_PREFIX, this.uniqueIdentifier, envelope.getChannel(), envelope.getBody(), envelope.getPayload());
        }
        if (LOG.isTraceEnabled()) {
            ProtonFrameLoggingHandler.log(AMQP_IN_PREFIX, this.uniqueIdentifier, envelope.getChannel(), envelope.getBody(), envelope.getPayload());
        }
        context.fireRead(envelope);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, HeaderEnvelope envelope) {
        if (this.traceFrames) {
            ProtonFrameLoggingHandler.trace(envelope.isSaslHeader() ? SASL_OUT_PREFIX : AMQP_OUT_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), null);
        }
        ProtonFrameLoggingHandler.log(envelope.isSaslHeader() ? SASL_OUT_PREFIX : AMQP_OUT_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), null);
        context.fireWrite(envelope);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, OutgoingAMQPEnvelope envelope) {
        if (this.traceFrames) {
            ProtonFrameLoggingHandler.trace(AMQP_OUT_PREFIX, this.uniqueIdentifier, envelope.getChannel(), envelope.getBody(), envelope.getPayload());
        }
        if (LOG.isTraceEnabled()) {
            ProtonFrameLoggingHandler.log(AMQP_OUT_PREFIX, this.uniqueIdentifier, envelope.getChannel(), envelope.getBody(), envelope.getPayload());
        }
        context.fireWrite(envelope);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, SASLEnvelope envelope) {
        if (this.traceFrames) {
            ProtonFrameLoggingHandler.trace(SASL_OUT_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), null);
        }
        ProtonFrameLoggingHandler.log(SASL_OUT_PREFIX, this.uniqueIdentifier, 0, envelope.getBody(), null);
        context.fireWrite(envelope);
    }

    private static final void log(String prefix, int connection, int channel, Object performative, ProtonBuffer payload) {
        if (payload == null) {
            LOG.trace("{}:[{}:{}] {}", prefix, connection, channel, performative);
        } else {
            LOG.trace("{}:[{}:{}] {} - {}", prefix, connection, channel, performative, StringUtils.toQuotedString(payload, 64, true));
        }
    }

    private static final void trace(String prefix, int connection, int channel, Object performative, ProtonBuffer payload) {
        if (payload == null) {
            System.out.println(String.format("%s:[%d:%d] %s", prefix, connection, channel, performative));
        } else {
            System.out.println(String.format("%s:[%d:%d] %s - %s", prefix, connection, channel, performative, StringUtils.toQuotedString(payload, 64, true)));
        }
    }
}

