/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Source;
import org.apache.qpid.protonj2.types.messaging.Target;
import org.apache.qpid.protonj2.types.messaging.Terminus;
import org.apache.qpid.protonj2.types.transactions.Coordinator;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.Performative;
import org.apache.qpid.protonj2.types.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.types.transport.Role;
import org.apache.qpid.protonj2.types.transport.SenderSettleMode;

public final class Attach
implements Performative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(18L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:attach:list");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int NAME = 1;
    private static final int HANDLE = 2;
    private static final int ROLE = 4;
    private static final int SENDER_SETTLE_MODE = 8;
    private static final int RECEIVER_SETTLE_MODE = 16;
    private static final int SOURCE = 32;
    private static final int TARGET = 64;
    private static final int UNSETTLED = 128;
    private static final int INCOMPLETE_UNSETTLED = 256;
    private static final int INITIAL_DELIVERY_COUNT = 512;
    private static final int MAX_MESSAGE_SIZE = 1024;
    private static final int OFFERED_CAPABILITIES = 2048;
    private static final int DESIRED_CAPABILITIES = 4096;
    private static final int PROPERTIES = 8192;
    private int modified = 0;
    private String name;
    private long handle;
    private Role role = Role.SENDER;
    private SenderSettleMode sndSettleMode = SenderSettleMode.MIXED;
    private ReceiverSettleMode rcvSettleMode = ReceiverSettleMode.FIRST;
    private Source source;
    private Terminus target;
    private Map<Binary, DeliveryState> unsettled;
    private boolean incompleteUnsettled;
    private long initialDeliveryCount;
    private UnsignedLong maxMessageSize;
    private Symbol[] offeredCapabilities;
    private Symbol[] desiredCapabilities;
    private Map<Symbol, Object> properties;

    @Override
    public Performative.PerformativeType getPerformativeType() {
        return Performative.PerformativeType.ATTACH;
    }

    @Override
    public Attach copy() {
        Attach copy = new Attach();
        copy.name = this.name;
        copy.handle = this.handle;
        copy.role = this.role;
        copy.sndSettleMode = this.sndSettleMode;
        copy.rcvSettleMode = this.rcvSettleMode;
        copy.source = this.source;
        copy.target = this.target;
        if (this.unsettled != null) {
            copy.unsettled = new LinkedHashMap<Binary, DeliveryState>(this.unsettled);
        }
        copy.incompleteUnsettled = this.incompleteUnsettled;
        copy.initialDeliveryCount = this.initialDeliveryCount;
        copy.maxMessageSize = this.maxMessageSize;
        if (this.offeredCapabilities != null) {
            copy.offeredCapabilities = Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length);
        }
        if (this.desiredCapabilities != null) {
            copy.desiredCapabilities = Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length);
        }
        if (this.properties != null) {
            copy.properties = new LinkedHashMap<Symbol, Object>(this.properties);
        }
        copy.modified = this.modified;
        return copy;
    }

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasElement(int index) {
        int value = 1 << index;
        return (this.modified & value) == value;
    }

    public boolean hasName() {
        return (this.modified & 1) == 1;
    }

    public boolean hasHandle() {
        return (this.modified & 2) == 2;
    }

    public boolean hasRole() {
        return (this.modified & 4) == 4;
    }

    public boolean hasSenderSettleMode() {
        return (this.modified & 8) == 8;
    }

    public boolean hasReceiverSettleMode() {
        return (this.modified & 0x10) == 16;
    }

    public boolean hasSource() {
        return (this.modified & 0x20) == 32;
    }

    public boolean hasTargetOrCoordinator() {
        return (this.modified & 0x40) == 64;
    }

    public boolean hasTarget() {
        return (this.modified & 0x40) == 64 && this.target instanceof Target;
    }

    public boolean hasCoordinator() {
        return (this.modified & 0x40) == 64 && this.target instanceof Coordinator;
    }

    public boolean hasUnsettled() {
        return (this.modified & 0x80) == 128;
    }

    public boolean hasIncompleteUnsettled() {
        return (this.modified & 0x100) == 256;
    }

    public boolean hasInitialDeliveryCount() {
        return (this.modified & 0x200) == 512;
    }

    public boolean hasMaxMessageSize() {
        return (this.modified & 0x400) == 1024;
    }

    public boolean hasOfferedCapabilities() {
        return (this.modified & 0x800) == 2048;
    }

    public boolean hasDesiredCapabilities() {
        return (this.modified & 0x1000) == 4096;
    }

    public boolean hasProperties() {
        return (this.modified & 0x2000) == 8192;
    }

    public String getName() {
        return this.name;
    }

    public Attach setName(String name) {
        if (name == null) {
            throw new NullPointerException("the name field is mandatory");
        }
        this.modified |= 1;
        this.name = name;
        return this;
    }

    public long getHandle() {
        return this.handle;
    }

    public Attach setHandle(int handle) {
        this.modified |= 2;
        this.handle = Integer.toUnsignedLong(handle);
        return this;
    }

    public Attach setHandle(long handle) {
        if (handle < 0L || handle > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("The Handle value given is out of range: " + handle);
        }
        this.modified |= 2;
        this.handle = handle;
        return this;
    }

    public Role getRole() {
        return this.role;
    }

    public Attach setRole(Role role) {
        if (role == null) {
            throw new NullPointerException("Role cannot be null");
        }
        this.modified |= 4;
        this.role = role;
        return this;
    }

    public SenderSettleMode getSenderSettleMode() {
        return this.sndSettleMode;
    }

    public Attach setSenderSettleMode(SenderSettleMode sndSettleMode) {
        this.modified = sndSettleMode != null ? (this.modified |= 8) : (this.modified &= 0xFFFFFFF7);
        this.sndSettleMode = sndSettleMode == null ? SenderSettleMode.MIXED : sndSettleMode;
        return this;
    }

    public ReceiverSettleMode getReceiverSettleMode() {
        return this.rcvSettleMode;
    }

    public Attach setReceiverSettleMode(ReceiverSettleMode rcvSettleMode) {
        this.modified = rcvSettleMode != null ? (this.modified |= 0x10) : (this.modified &= 0xFFFFFFEF);
        this.rcvSettleMode = rcvSettleMode == null ? ReceiverSettleMode.FIRST : rcvSettleMode;
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    public Attach setSource(Source source) {
        this.modified = source != null ? (this.modified |= 0x20) : (this.modified &= 0xFFFFFFDF);
        this.source = source;
        return this;
    }

    public <T extends Terminus> T getTarget() {
        return (T)this.target;
    }

    public Attach setTarget(Terminus target) {
        if (target instanceof Target) {
            this.setTarget((Target)target);
        } else if (target instanceof Coordinator) {
            this.setTarget((Coordinator)target);
        } else {
            throw new IllegalArgumentException("Cannot set Target terminus to given value: " + String.valueOf(target));
        }
        return this;
    }

    public Attach setTarget(Target target) {
        this.modified = target != null ? (this.modified |= 0x40) : (this.modified &= 0xFFFFFFBF);
        this.target = target;
        return this;
    }

    public Attach setTarget(Coordinator target) {
        this.modified = target != null ? (this.modified |= 0x40) : (this.modified &= 0xFFFFFFBF);
        this.target = target;
        return this;
    }

    public Attach setCoordinator(Coordinator target) {
        this.modified = target != null ? (this.modified |= 0x40) : (this.modified &= 0xFFFFFFBF);
        this.target = target;
        return this;
    }

    public Map<Binary, DeliveryState> getUnsettled() {
        return this.unsettled;
    }

    public Attach setUnsettled(Map<Binary, DeliveryState> unsettled) {
        this.modified = unsettled != null ? (this.modified |= 0x80) : (this.modified &= 0xFFFFFF7F);
        this.unsettled = unsettled;
        return this;
    }

    public boolean getIncompleteUnsettled() {
        return this.incompleteUnsettled;
    }

    public Attach setIncompleteUnsettled(boolean incompleteUnsettled) {
        this.modified |= 0x100;
        this.incompleteUnsettled = incompleteUnsettled;
        return this;
    }

    public long getInitialDeliveryCount() {
        return this.initialDeliveryCount;
    }

    public Attach setInitialDeliveryCount(int initialDeliveryCount) {
        this.modified |= 0x200;
        this.initialDeliveryCount = Integer.toUnsignedLong(initialDeliveryCount);
        return this;
    }

    public Attach setInitialDeliveryCount(long initialDeliveryCount) {
        if (initialDeliveryCount < 0L || initialDeliveryCount > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("The initial delivery count value given is out of range: " + this.handle);
        }
        this.modified |= 0x200;
        this.initialDeliveryCount = initialDeliveryCount;
        return this;
    }

    public UnsignedLong getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Attach setMaxMessageSize(long maxMessageSize) {
        return this.setMaxMessageSize(UnsignedLong.valueOf(maxMessageSize));
    }

    public Attach setMaxMessageSize(UnsignedLong maxMessageSize) {
        this.modified = maxMessageSize != null ? (this.modified |= 0x400) : (this.modified &= 0xFFFFFBFF);
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public Symbol[] getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public Attach setOfferedCapabilities(Symbol ... offeredCapabilities) {
        this.modified = offeredCapabilities != null ? (this.modified |= 0x800) : (this.modified &= 0xFFFFF7FF);
        this.offeredCapabilities = offeredCapabilities;
        return this;
    }

    public Symbol[] getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public Attach setDesiredCapabilities(Symbol ... desiredCapabilities) {
        this.modified = desiredCapabilities != null ? (this.modified |= 0x1000) : (this.modified &= 0xFFFFEFFF);
        this.desiredCapabilities = desiredCapabilities;
        return this;
    }

    public Map<Symbol, Object> getProperties() {
        return this.properties;
    }

    public Attach setProperties(Map<Symbol, Object> properties) {
        this.modified = properties != null ? (this.modified |= 0x2000) : (this.modified &= 0xFFFFDFFF);
        this.properties = properties;
        return this;
    }

    @Override
    public <E> void invoke(Performative.PerformativeHandler<E> handler, ProtonBuffer payload, int channel, E context) {
        handler.handleAttach(this, payload, channel, context);
    }

    public String toString() {
        return "Attach{name='" + this.name + "', handle=" + String.valueOf(this.hasHandle() ? Long.valueOf(this.handle) : "null") + ", role=" + String.valueOf(this.hasRole() ? this.role : "null") + ", sndSettleMode=" + String.valueOf(this.hasSenderSettleMode() ? this.sndSettleMode : "null") + ", rcvSettleMode=" + String.valueOf(this.hasReceiverSettleMode() ? this.rcvSettleMode : "null") + ", source=" + String.valueOf(this.source) + ", target=" + String.valueOf(this.target) + ", unsettled=" + String.valueOf(this.unsettled) + ", incompleteUnsettled=" + String.valueOf(this.hasIncompleteUnsettled() ? Boolean.valueOf(this.incompleteUnsettled) : "null") + ", initialDeliveryCount=" + String.valueOf(this.hasInitialDeliveryCount() ? Long.valueOf(this.initialDeliveryCount) : "null") + ", maxMessageSize=" + String.valueOf(this.maxMessageSize) + ", offeredCapabilities=" + String.valueOf(this.offeredCapabilities == null ? "null" : Arrays.asList(this.offeredCapabilities)) + ", desiredCapabilities=" + String.valueOf(this.desiredCapabilities == null ? "null" : Arrays.asList(this.desiredCapabilities)) + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

