/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.utils;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.utils.AutoIncrementIdGenerator;
import org.apache.seatunnel.shade.com.google.common.cache.Cache;
import org.apache.seatunnel.shade.com.google.common.cache.CacheBuilder;

public class IdGeneratorUtils {
    private static final Cache<String, AutoIncrementIdGenerator> idGenerators = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.MINUTES).build();

    public static synchronized Optional<AutoIncrementIdGenerator> getIdGenerator(String jobId, FakeConfig fakeConfig, String columnName) {
        CatalogTable catalogTable = fakeConfig.getCatalogTable();
        String tableName = catalogTable.getTableId().getTableName();
        String key = String.format("%s:%s_%s", jobId, tableName, columnName);
        AutoIncrementIdGenerator idGenerator = null;
        try {
            idGenerator = (AutoIncrementIdGenerator)idGenerators.get((Object)key, () -> {
                if (IdGeneratorUtils.isPrimaryColumn(fakeConfig, columnName)) {
                    return new AutoIncrementIdGenerator(fakeConfig.getAutoIncrementStart());
                }
                return null;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return Optional.ofNullable(idGenerator);
    }

    public static boolean isPrimaryColumn(FakeConfig fakeConfig, String columnName) {
        PrimaryKey primaryKey = fakeConfig.getCatalogTable().getTableSchema().getPrimaryKey();
        if (primaryKey == null) {
            return false;
        }
        List primaryColumns = primaryKey.getColumnNames();
        return primaryColumns != null && primaryColumns.contains(columnName);
    }
}

