/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.pb;

import com.google.protobuf.GeneratedMessage;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
public class PlacementConstraintToProtoConverter
implements PlacementConstraint.Visitor<GeneratedMessage> {
    private PlacementConstraint placementConstraint;

    public PlacementConstraintToProtoConverter(PlacementConstraint placementConstraint) {
        this.placementConstraint = placementConstraint;
    }

    public YarnProtos.PlacementConstraintProto convert() {
        return (YarnProtos.PlacementConstraintProto)this.placementConstraint.getConstraintExpr().accept(this);
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.SingleConstraint constraint) {
        YarnProtos.SimplePlacementConstraintProto.Builder sb = YarnProtos.SimplePlacementConstraintProto.newBuilder();
        if (constraint.getScope() != null) {
            sb.setScope(constraint.getScope());
        }
        sb.setMinCardinality(constraint.getMinCardinality());
        sb.setMaxCardinality(constraint.getMaxCardinality());
        if (constraint.getTargetExpressions() != null) {
            for (PlacementConstraint.TargetExpression target : constraint.getTargetExpressions()) {
                sb.addTargetExpressions((YarnProtos.PlacementConstraintTargetProto)target.accept(this));
            }
        }
        YarnProtos.SimplePlacementConstraintProto sProto = sb.build();
        YarnProtos.PlacementConstraintProto.Builder pb = YarnProtos.PlacementConstraintProto.newBuilder();
        pb.setSimpleConstraint(sProto);
        return pb.build();
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.TargetExpression target) {
        YarnProtos.PlacementConstraintTargetProto.Builder tb = YarnProtos.PlacementConstraintTargetProto.newBuilder();
        tb.setTargetType(ProtoUtils.convertToProtoFormat(target.getTargetType()));
        if (target.getTargetKey() != null) {
            tb.setTargetKey(target.getTargetKey());
        }
        if (target.getTargetValues() != null) {
            tb.addAllTargetValues(target.getTargetValues());
        }
        return tb.build();
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.TargetConstraint constraint) {
        throw new YarnRuntimeException("Unexpected TargetConstraint found.");
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.CardinalityConstraint constraint) {
        throw new YarnRuntimeException("Unexpected CardinalityConstraint found.");
    }

    private GeneratedMessage visitAndOr(PlacementConstraint.CompositeConstraint<PlacementConstraint.AbstractConstraint> composite, YarnProtos.CompositePlacementConstraintProto.CompositeType type) {
        YarnProtos.CompositePlacementConstraintProto.Builder cb = YarnProtos.CompositePlacementConstraintProto.newBuilder();
        cb.setCompositeType(type);
        for (PlacementConstraint.AbstractConstraint c : composite.getChildren()) {
            cb.addChildConstraints((YarnProtos.PlacementConstraintProto)c.accept(this));
        }
        YarnProtos.CompositePlacementConstraintProto cProto = cb.build();
        YarnProtos.PlacementConstraintProto.Builder pb = YarnProtos.PlacementConstraintProto.newBuilder();
        pb.setCompositeConstraint(cProto);
        return pb.build();
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.And constraint) {
        return this.visitAndOr(constraint, YarnProtos.CompositePlacementConstraintProto.CompositeType.AND);
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.Or constraint) {
        return this.visitAndOr(constraint, YarnProtos.CompositePlacementConstraintProto.CompositeType.OR);
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.DelayedOr constraint) {
        YarnProtos.CompositePlacementConstraintProto.Builder cb = YarnProtos.CompositePlacementConstraintProto.newBuilder();
        cb.setCompositeType(YarnProtos.CompositePlacementConstraintProto.CompositeType.DELAYED_OR);
        for (PlacementConstraint.TimedPlacementConstraint c : constraint.getChildren()) {
            cb.addTimedChildConstraints((YarnProtos.TimedPlacementConstraintProto)c.accept(this));
        }
        YarnProtos.CompositePlacementConstraintProto cProto = cb.build();
        YarnProtos.PlacementConstraintProto.Builder pb = YarnProtos.PlacementConstraintProto.newBuilder();
        pb.setCompositeConstraint(cProto);
        return pb.build();
    }

    @Override
    public GeneratedMessage visit(PlacementConstraint.TimedPlacementConstraint constraint) {
        YarnProtos.TimedPlacementConstraintProto.Builder tb = YarnProtos.TimedPlacementConstraintProto.newBuilder();
        tb.setDelayUnit(ProtoUtils.convertToProtoFormat(constraint.getDelayUnit()));
        tb.setSchedulingDelay(constraint.getSchedulingDelay());
        tb.setPlacementConstraint((YarnProtos.PlacementConstraintProto)constraint.getConstraint().accept(this));
        return tb.build();
    }
}

