/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.connectors.seatunnel.sls.config;

import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;

public class SlsSinkOptions extends SlsBaseOptions {

    public static final Option<String> SOURCE =
            Options.key("source")
                    .stringType()
                    .defaultValue("SeaTunnel-Source")
                    .withDescription("Aliyun sls producer source");

    public static final Option<String> TOPIC =
            Options.key("topic")
                    .stringType()
                    .defaultValue("SeaTunnel-Topic")
                    .withDescription("Aliyun sls producer topic");

    public static final Option<Integer> LOG_GROUP_SIZE =
            Options.key("log_group_size")
                    .intType()
                    .defaultValue(100)
                    .withDescription("Aliyun sls log group write size");
}
