% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_index_op.R
\name{sedona_build_index}
\alias{sedona_build_index}
\title{Build an index on a Sedona spatial RDD.}
\usage{
sedona_build_index(
  rdd,
  type = c("quadtree", "rtree"),
  index_spatial_partitions = TRUE
)
}
\arguments{
\item{rdd}{The spatial RDD to be indexed.}

\item{type}{The type of index to build. Currently "quadtree" and "rtree" are
supported.}

\item{index_spatial_partitions}{If the RDD is already partitioned using a
spatial partitioner, then index each spatial partition within the RDD
instead of partitions within the raw RDD associated with the underlying
spatial data source. Default: TRUE.
Notice this option is irrelevant if the input RDD has not been partitioned
using with a spatial partitioner yet.}
}
\value{
A spatial index object.
}
\description{
Given a Sedona spatial RDD, build the type of index specified on each of its
partition(s).
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_shapefile_to_typed_rdd(
    sc,
    location = input_location,
    type = "polygon"
  )
  sedona_build_index(rdd, type = "rtree")
}

}
