/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import org.apache.servicecomb.codec.protobuf.definition.RequestRootSerializer;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootSerializer;
import org.apache.servicecomb.foundation.protobuf.RootSerializer;
import org.apache.servicecomb.foundation.vertx.tcp.TcpOutputStream;
import org.apache.servicecomb.transport.highway.message.RequestHeader;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;

public class HighwayOutputStream
extends TcpOutputStream {
    public HighwayOutputStream(long msgId) {
        super(msgId);
    }

    public void write(RequestHeader header, RequestRootSerializer requestRootSerializer, Object body) throws Exception {
        this.write(RequestHeader.getRootSerializer().serialize((Object)header), requestRootSerializer.serialize(body));
    }

    public void write(ResponseHeader header, ResponseRootSerializer responseRootSerializer, Object body) throws Exception {
        this.write(ResponseHeader.getRootSerializer().serialize((Object)header), responseRootSerializer.serialize(body));
    }

    public void write(RequestHeader header, RootSerializer bodySerializer, Object body) throws Exception {
        this.write(RequestHeader.getRootSerializer(), header, bodySerializer, body);
    }

    public void write(ResponseHeader header, RootSerializer bodySerializer, Object body) throws Exception {
        this.write(ResponseHeader.getRootSerializer(), header, bodySerializer, body);
    }

    public void write(RootSerializer headerSerializer, Object header, RootSerializer bodySerializer, Object body) throws Exception {
        byte[] headerBytes = new byte[]{};
        byte[] bodyBytes = new byte[]{};
        if (headerSerializer != null) {
            headerBytes = headerSerializer.serialize(header);
        }
        if (bodySerializer != null) {
            bodyBytes = bodySerializer.serialize(body);
        }
        this.write(headerBytes, bodyBytes);
    }

    private void write(byte[] headerBytes, byte[] bodyBytes) throws Exception {
        int headerLength = 0;
        int totalLength = 0;
        if (headerBytes != null) {
            headerLength = headerBytes.length;
            totalLength += headerLength;
        }
        if (bodyBytes != null) {
            totalLength += bodyBytes.length;
        }
        this.writeLength(totalLength, headerLength);
        this.write(headerBytes);
        this.write(bodyBytes);
    }
}

