/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.batch.builder;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisPagingItemReader;

public class MyBatisPagingItemReaderBuilder<T> {
    private SqlSessionFactory sqlSessionFactory;
    private String queryId;
    private Map<String, Object> parameterValues;
    private Supplier<Map<String, Object>> parameterValuesSupplier;
    private Integer pageSize;
    private Boolean saveState;
    private Integer maxItemCount;

    public MyBatisPagingItemReaderBuilder<T> sqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> parameterValuesSupplier(Supplier<Map<String, Object>> parameterValuesSupplier) {
        this.parameterValuesSupplier = parameterValuesSupplier;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MyBatisPagingItemReader<T> build() {
        MyBatisPagingItemReader reader = new MyBatisPagingItemReader();
        reader.setSqlSessionFactory(this.sqlSessionFactory);
        reader.setQueryId(this.queryId);
        reader.setParameterValues(this.parameterValues);
        reader.setParameterValuesSupplier(this.parameterValuesSupplier);
        Optional.ofNullable(this.pageSize).ifPresent(arg_0 -> reader.setPageSize(arg_0));
        Optional.ofNullable(this.saveState).ifPresent(arg_0 -> reader.setSaveState(arg_0));
        Optional.ofNullable(this.maxItemCount).ifPresent(arg_0 -> reader.setMaxItemCount(arg_0));
        return reader;
    }
}

