/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel;

import com.alibaba.csp.sentinel.CtEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.ErrorEntryFreeException;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.NullContext;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;

public class AsyncEntry
extends CtEntry {
    private Context asyncContext;

    AsyncEntry(ResourceWrapper resourceWrapper, ProcessorSlot<Object> chain, Context context) {
        super(resourceWrapper, chain, context);
    }

    void cleanCurrentEntryInLocal() {
        if (this.context instanceof NullContext) {
            return;
        }
        Context originalContext = this.context;
        if (originalContext != null) {
            Entry curEntry = originalContext.getCurEntry();
            if (curEntry == this) {
                Entry parent = this.parent;
                originalContext.setCurEntry(parent);
                if (parent != null) {
                    ((CtEntry)parent).child = null;
                }
            } else {
                String curEntryName = curEntry == null ? "none" : curEntry.resourceWrapper.getName() + "@" + curEntry.hashCode();
                String msg = String.format("Bad async context state, expected entry: %s, but actual: %s", this.getResourceWrapper().getName() + "@" + this.hashCode(), curEntryName);
                throw new IllegalStateException(msg);
            }
        }
    }

    public Context getAsyncContext() {
        return this.asyncContext;
    }

    void initAsyncContext() {
        if (this.asyncContext == null) {
            if (this.context instanceof NullContext) {
                this.asyncContext = this.context;
                return;
            }
            this.asyncContext = Context.newAsyncContext(this.context.getEntranceNode(), this.context.getName()).setOrigin(this.context.getOrigin()).setCurEntry(this);
        } else {
            RecordLog.warn("[AsyncEntry] Duplicate initialize of async context for entry: " + this.resourceWrapper.getName(), new Object[0]);
        }
    }

    @Override
    protected void clearEntryContext() {
        super.clearEntryContext();
        this.asyncContext = null;
    }

    @Override
    protected Entry trueExit(int count, Object ... args) throws ErrorEntryFreeException {
        this.exitForContext(this.asyncContext, count, args);
        return this.parent;
    }
}

