/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Node;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;

public abstract class AbstractNode
implements Node {
    protected URL url;
    protected volatile boolean init = false;
    protected volatile boolean available = false;

    public AbstractNode(URL url) {
        this.url = url;
    }

    @Override
    public synchronized void init() {
        if (this.init) {
            LoggerUtil.warn(this.getClass().getSimpleName() + " node already init: " + this.desc());
            return;
        }
        boolean result = this.doInit();
        if (!result) {
            LoggerUtil.error(this.getClass().getSimpleName() + " node init Error: " + this.desc());
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " node init Error: " + this.desc(), MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        LoggerUtil.info(this.getClass().getSimpleName() + " node init Success: " + this.desc());
        this.init = true;
        this.available = true;
    }

    protected abstract boolean doInit();

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }
}

