/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.DefaultChatOptions;

public class DefaultChatOptionsBuilder
implements ChatOptions.Builder {
    protected DefaultChatOptions options;

    public DefaultChatOptionsBuilder() {
        this.options = new DefaultChatOptions();
    }

    protected DefaultChatOptionsBuilder(DefaultChatOptions options) {
        this.options = options;
    }

    @Override
    public DefaultChatOptionsBuilder model(String model) {
        this.options.setModel(model);
        return this;
    }

    @Override
    public DefaultChatOptionsBuilder frequencyPenalty(Double frequencyPenalty) {
        this.options.setFrequencyPenalty(frequencyPenalty);
        return this;
    }

    @Override
    public DefaultChatOptionsBuilder maxTokens(Integer maxTokens) {
        this.options.setMaxTokens(maxTokens);
        return this;
    }

    @Override
    public DefaultChatOptionsBuilder presencePenalty(Double presencePenalty) {
        this.options.setPresencePenalty(presencePenalty);
        return this;
    }

    @Override
    public DefaultChatOptionsBuilder stopSequences(List<String> stop) {
        this.options.setStopSequences(stop);
        return this;
    }

    @Override
    public DefaultChatOptionsBuilder temperature(Double temperature) {
        this.options.setTemperature(temperature);
        return this;
    }

    @Override
    public DefaultChatOptionsBuilder topK(Integer topK) {
        this.options.setTopK(topK);
        return this;
    }

    @Override
    public DefaultChatOptionsBuilder topP(Double topP) {
        this.options.setTopP(topP);
        return this;
    }

    @Override
    public ChatOptions build() {
        return this.options.copy();
    }
}

