/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.core.AbstractNodeDataSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosSyncDataService
extends AbstractNodeDataSyncService
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(NacosSyncDataService.class);
    private final ConcurrentHashMap<String, Listener> watchCache = new ConcurrentHashMap();
    private final ConfigService configService;

    public NacosSyncDataService(ConfigService configService, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers, ShenyuConfig shenyuConfig) {
        super(new AbstractNodeDataSyncService.ChangeData("plugin", "selector", "rule", "auth", "meta", "proxy.selector", "discovery"), pluginDataSubscriber, metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers, shenyuConfig);
        this.configService = configService;
        this.startWatch();
    }

    protected void doRemoveListener(String key) {
        Listener listener = this.watchCache.get(key);
        if (!ObjectUtils.isEmpty((Object)listener)) {
            this.configService.removeListener(key, "DEFAULT_GROUP", listener);
            this.watchCache.remove(key);
        }
    }

    protected String getServiceConfig(final String key, final Consumer<String> updateHandler, final Consumer<String> deleteHandler) {
        try {
            if (this.watchCache.containsKey(key)) {
                return null;
            }
            Listener listener = new Listener(){

                public Executor getExecutor() {
                    return null;
                }

                public void receiveConfigInfo(String configInfo) {
                    try {
                        if (StringUtils.isBlank((CharSequence)configInfo) && Objects.nonNull(deleteHandler)) {
                            deleteHandler.accept(key);
                        } else {
                            updateHandler.accept(configInfo);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("nacos sync listener receiveConfigInfo error", (Throwable)e);
                    }
                }
            };
            String serviceConfig = this.configService.getConfigAndSignListener(key, "DEFAULT_GROUP", 3000L, listener);
            this.watchCache.put(key, listener);
            return serviceConfig;
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void close() {
        this.watchCache.forEach((dataId, lss) -> {
            this.configService.removeListener(dataId, "DEFAULT_GROUP", lss);
            this.watchCache.remove(dataId);
            LOG.info("nacos sync remove listener key:{}", dataId);
        });
    }
}

