/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;

public class ApiBean {
    private final String clientName;
    private final String beanName;
    private final Object beanInstance;
    private final Class<?> beanClass;
    private final List<ApiDefinition> apiDefinitions;
    private String beanPath = "";
    private final Properties beanProperties = new Properties();
    private Status status = Status.INIT;

    public ApiBean(@NonNull String clientName, @NonNull String beanName, @NonNull Object beanInstance, @NonNull List<ApiDefinition> apiDefinitions) {
        this.clientName = clientName;
        this.beanName = beanName;
        this.beanInstance = beanInstance;
        this.beanClass = this.getCorrectedClass(beanInstance);
        this.apiDefinitions = apiDefinitions;
        for (ApiDefinition apiDefinition : apiDefinitions) {
            apiDefinition.apiBean = this;
        }
    }

    public ApiBean(@NonNull String clientName, @NonNull String beanName, @NonNull Object beanInstance) {
        this.clientName = clientName;
        this.beanName = beanName;
        this.beanInstance = beanInstance;
        this.beanClass = this.getCorrectedClass(beanInstance);
        this.apiDefinitions = new ArrayList<ApiDefinition>(5);
    }

    public ApiBean(@NonNull String clientName, @NonNull String beanName, @NonNull Object beanInstance, String beanPath) {
        this.clientName = clientName;
        this.beanName = beanName;
        this.beanInstance = beanInstance;
        this.beanClass = this.getCorrectedClass(beanInstance);
        this.beanPath = beanPath;
        this.apiDefinitions = new ArrayList<ApiDefinition>(5);
    }

    public void addApiDefinition(Method method, String methodPath) {
        ApiDefinition apiDefinition = new ApiDefinition(this, method, methodPath);
        this.apiDefinitions.add(apiDefinition);
    }

    public String getClientName() {
        return this.clientName;
    }

    public List<ApiDefinition> getApiDefinitions() {
        return this.apiDefinitions;
    }

    public Object getBeanInstance() {
        return this.beanInstance;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getBeanPath() {
        return this.beanPath;
    }

    public void addProperties(String name, String value) {
        this.beanProperties.put(name, value);
    }

    public String getPropertiesValue(String name) {
        return this.beanProperties.getProperty(name);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)AnnotatedElementUtils.findMergedAnnotation(this.beanClass, annotationClass);
    }

    private Class<?> getCorrectedClass(Object bean) {
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy((Object)bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        return clazz;
    }

    public void setBeanPath(String beanPath) {
        this.beanPath = beanPath;
    }

    public ApiBean copy() {
        ApiBean copy = new ApiBean(this.clientName, this.beanName, this.beanInstance, this.beanPath);
        this.beanProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> copy.addProperties(k.toString(), Objects.toString(v))));
        for (ApiDefinition definition : this.apiDefinitions) {
            ApiDefinition newDefinition = new ApiDefinition(this, definition.apiMethod, definition.methodPath);
            definition.apiProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> newDefinition.addProperties(k.toString(), Objects.toString(v))));
            copy.apiDefinitions.add(newDefinition);
        }
        return copy;
    }

    public static enum Status {
        INIT,
        CAN_NO_BE_REGISTERED,
        REGISTRABLE,
        REGISTRABLE_API,
        REGISTRABLE_BEAN,
        REGISTERED;

    }

    public static final class ApiDefinition {
        private final Method apiMethod;
        private ApiBean apiBean;
        private String methodPath;
        private final Properties apiProperties = new Properties();
        private Status status = Status.INIT;

        public ApiDefinition(Method apiMethod) {
            this.apiMethod = apiMethod;
            this.methodPath = apiMethod.getName();
        }

        public ApiDefinition(ApiBean apiBean, Method apiMethod) {
            this.apiBean = apiBean;
            this.apiMethod = apiMethod;
        }

        private ApiDefinition(ApiBean apiBean, Method apiMethod, String methodPath) {
            this.apiBean = apiBean;
            this.apiMethod = apiMethod;
            this.methodPath = methodPath;
        }

        public void setMethodPath(String methodPath) {
            this.methodPath = methodPath;
        }

        public void addProperties(String name, String value) {
            this.apiProperties.put(name, value);
        }

        public String getPropertiesValue(String name) {
            return this.apiProperties.getProperty(name);
        }

        public Method getApiMethod() {
            return this.apiMethod;
        }

        public String getApiMethodName() {
            return this.apiMethod.getName();
        }

        public String getBeanPath() {
            return this.apiBean.beanPath;
        }

        public String getMethodPath() {
            return this.methodPath;
        }

        public Class<?> getBeanClass() {
            return this.apiBean.beanClass;
        }

        public ApiBean getApiBean() {
            return this.apiBean;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return (A)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.apiMethod, annotationClass);
        }

        public String getParameterTypes() {
            return Optional.ofNullable(this.apiMethod).map(m -> Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(","))).orElse(null);
        }
    }
}

