/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api;

import com.alipay.lookout.api.NoopRegistry;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.common.Assert;
import java.util.concurrent.atomic.AtomicReference;

public final class Lookout {
    private static final AtomicReference<Registry> atomicRegistryReference = new AtomicReference<NoopRegistry>(NoopRegistry.INSTANCE);

    public static Registry registry() {
        return atomicRegistryReference.get();
    }

    public static void setRegistry(Registry registry) {
        if (registry == NoopRegistry.INSTANCE) {
            return;
        }
        Assert.state(atomicRegistryReference.compareAndSet(NoopRegistry.INSTANCE, registry), String.format("Global registry can only reset one time! current is %s", atomicRegistryReference.get()));
    }

    private Lookout() {
    }
}

