/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.infra.etcd.config;

import java.util.StringJoiner;

public class EtcdConfig {
    private String url;
    private Integer sessionTimeout;
    private Integer connectionTimeout;
    private String serializer;

    public EtcdConfig(String url, Integer session, Integer connection, String serializer) {
        this.url = url;
        this.sessionTimeout = session;
        this.connectionTimeout = connection;
        this.serializer = serializer;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public void setSerializer(String serializer) {
        this.serializer = serializer;
    }

    public String toString() {
        return new StringJoiner(", ", EtcdConfig.class.getSimpleName() + "[", "]").add("url='" + this.url + "'").add("sessionTimeout=" + this.sessionTimeout).add("connectionTimeout=" + this.connectionTimeout).add("serializer='" + this.serializer + "'").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String url;
        private Integer sessionTimeout;
        private Integer connectionTimeout;
        private String serializer;

        private Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder serializer(String serializer) {
            this.serializer = serializer;
            return this;
        }

        public EtcdConfig build() {
            return new EtcdConfig(this.url, this.sessionTimeout, this.connectionTimeout, this.serializer);
        }
    }
}

