/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer;

import java.util.Locale;

public class ProducerConfig {
    public static final int DEFAULT_TOTAL_SIZE_IN_BYTES = 0x6400000;
    public static final long DEFAULT_MAX_BLOCK_MS = 60000L;
    public static final int DEFAULT_IO_THREAD_COUNT = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    public static final int DEFAULT_BATCH_SIZE_THRESHOLD_IN_BYTES = 524288;
    public static final int MAX_BATCH_SIZE_IN_BYTES = 0xA00000;
    public static final int MAX_SINGLE_LOG_SIZE_IN_BYTES = 0x100000;
    public static final int DEFAULT_BATCH_COUNT_THRESHOLD = 4096;
    public static final int MAX_BATCH_COUNT = 40960;
    public static final int DEFAULT_LINGER_MS = 2000;
    public static final int LINGER_MS_LOWER_LIMIT = 100;
    public static final int DEFAULT_RETRIES = 10;
    public static final long DEFAULT_BASE_RETRY_BACKOFF_MS = 100L;
    public static final long DEFAULT_MAX_RETRY_BACKOFF_MS = 50000L;
    public static final LogFormat DEFAULT_LOG_FORMAT = LogFormat.PROTOBUF;
    private int totalSizeInBytes = 0x6400000;
    private int maxSingleLogSizeInBytes = 0x100000;
    private boolean giveUpExtraLongSingleLog = false;
    private long maxBlockMs = 60000L;
    private int ioThreadCount = DEFAULT_IO_THREAD_COUNT;
    private int batchSizeThresholdInBytes = 524288;
    private int batchCountThreshold = 4096;
    private int lingerMs = 2000;
    private int retries = 10;
    private int maxReservedAttempts = 11;
    private long baseRetryBackoffMs = 100L;
    private long maxRetryBackoffMs = 50000L;
    private LogFormat logFormat = DEFAULT_LOG_FORMAT;
    private String appName;
    private String pathFile;
    private String projectId;
    private boolean isLogBackSdk = false;
    private boolean enableLocalTest = false;

    public boolean isGiveUpExtraLongSingleLog() {
        return this.giveUpExtraLongSingleLog;
    }

    public void setGiveUpExtraLongSingleLog(boolean giveUpExtraLongSingleLog) {
        this.giveUpExtraLongSingleLog = giveUpExtraLongSingleLog;
    }

    public int getMaxSingleLogSizeInBytes() {
        return this.maxSingleLogSizeInBytes;
    }

    public void setMaxSingleLogSizeInBytes(int maxSingleLogSizeInBytes) {
        if (maxSingleLogSizeInBytes < 1 || maxSingleLogSizeInBytes > 0x100000) {
            throw new IllegalArgumentException("maxSingleLogSizeInBytes must 500k ~ 1M " + maxSingleLogSizeInBytes);
        }
        this.maxSingleLogSizeInBytes = maxSingleLogSizeInBytes;
    }

    public int getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) {
        if (totalSizeInBytes <= 0) {
            throw new IllegalArgumentException("totalSizeInBytes must be greater than 0, got " + totalSizeInBytes);
        }
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public long getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public void setMaxBlockMs(long maxBlockMs) {
        this.maxBlockMs = maxBlockMs;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public void setIoThreadCount(int ioThreadCount) {
        if (ioThreadCount <= 0) {
            throw new IllegalArgumentException("ioThreadCount must be greater than 0, got " + ioThreadCount);
        }
        this.ioThreadCount = ioThreadCount;
    }

    public int getBatchSizeThresholdInBytes() {
        return this.batchSizeThresholdInBytes;
    }

    public void setBatchSizeThresholdInBytes(int batchSizeThresholdInBytes) {
        if (batchSizeThresholdInBytes < 1 || batchSizeThresholdInBytes > 0xA00000) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "batchSizeThresholdInBytes must be between 1 and %d, got %d", 0xA00000, batchSizeThresholdInBytes));
        }
        this.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
    }

    public int getBatchCountThreshold() {
        return this.batchCountThreshold;
    }

    public void setBatchCountThreshold(int batchCountThreshold) {
        if (batchCountThreshold < 1 || batchCountThreshold > 40960) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "batchCountThreshold must be between 1 and %d, got %d", 40960, batchCountThreshold));
        }
        this.batchCountThreshold = batchCountThreshold;
    }

    public int getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(int lingerMs) {
        if (lingerMs < 100) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "lingerMs must be greater than or equal to %d, got %d", 100, lingerMs));
        }
        this.lingerMs = lingerMs;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getMaxReservedAttempts() {
        return this.maxReservedAttempts;
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) {
        if (maxReservedAttempts <= 0) {
            throw new IllegalArgumentException("maxReservedAttempts must be greater than 0, got " + maxReservedAttempts);
        }
        this.maxReservedAttempts = maxReservedAttempts;
    }

    public long getBaseRetryBackoffMs() {
        return this.baseRetryBackoffMs;
    }

    public void setBaseRetryBackoffMs(long baseRetryBackoffMs) {
        if (baseRetryBackoffMs <= 0L) {
            throw new IllegalArgumentException("baseRetryBackoffMs must be greater than 0, got " + baseRetryBackoffMs);
        }
        this.baseRetryBackoffMs = baseRetryBackoffMs;
    }

    public long getMaxRetryBackoffMs() {
        return this.maxRetryBackoffMs;
    }

    public void setMaxRetryBackoffMs(long maxRetryBackoffMs) {
        if (maxRetryBackoffMs <= 0L) {
            throw new IllegalArgumentException("maxRetryBackoffMs must be greater than 0, got " + maxRetryBackoffMs);
        }
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }

    public LogFormat getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPathFile() {
        return this.pathFile;
    }

    public void setPathFile(String pathFile) {
        this.pathFile = pathFile;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean isLogBackSdk() {
        return this.isLogBackSdk;
    }

    public void setLogBackSdk(boolean logBackSdk) {
        this.isLogBackSdk = logBackSdk;
    }

    public boolean isEnableLocalTest() {
        return this.enableLocalTest;
    }

    public void setEnableLocalTest(boolean enableLocalTest) {
        this.enableLocalTest = enableLocalTest;
    }

    public static enum LogFormat {
        PROTOBUF,
        JSON;

    }
}

