/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.internals;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogThread.class);

    public static LogThread daemon(String name, Runnable runnable) {
        return new LogThread(name, runnable, true);
    }

    public static LogThread nonDaemon(String name, Runnable runnable) {
        return new LogThread(name, runnable, false);
    }

    public LogThread(String name, boolean daemon) {
        super(name);
        this.configureThread(name, daemon);
    }

    public LogThread(String name, Runnable runnable, boolean daemon) {
        super(runnable, name);
        this.configureThread(name, daemon);
    }

    private void configureThread(final String name, boolean daemon) {
        this.setDaemon(daemon);
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Uncaught error in thread, name={}, e=", (Object)name, (Object)e);
            }
        });
    }
}

