/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.internals;

import com.huaweicloud.lts.producer.ProducerConfig;
import com.huaweicloud.lts.producer.http.Client;
import com.huaweicloud.lts.producer.internals.ExpiredBatches;
import com.huaweicloud.lts.producer.internals.IOThreadPool;
import com.huaweicloud.lts.producer.internals.LogAccumulator;
import com.huaweicloud.lts.producer.internals.LogThread;
import com.huaweicloud.lts.producer.internals.ProducerBatch;
import com.huaweicloud.lts.producer.internals.RetryQueue;
import com.huaweicloud.lts.producer.internals.SendProducerBatchTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mover
extends LogThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBatch.class);
    private final ProducerConfig producerConfig;
    private final Map<String, Client> clientPool;
    private final LogAccumulator accumulator;
    private final RetryQueue retryQueue;
    private final BlockingQueue<ProducerBatch> successQueue;
    private final BlockingQueue<ProducerBatch> failureQueue;
    private final IOThreadPool ioThreadPool;
    private final AtomicInteger batchCount;
    private volatile boolean closed;

    public Mover(String name, ProducerConfig producerConfig, Map<String, Client> clientPool, LogAccumulator accumulator, RetryQueue retryQueue, BlockingQueue<ProducerBatch> successQueue, BlockingQueue<ProducerBatch> failureQueue, IOThreadPool ioThreadPool, AtomicInteger batchCount) {
        super(name, true);
        this.producerConfig = producerConfig;
        this.clientPool = clientPool;
        this.accumulator = accumulator;
        this.retryQueue = retryQueue;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.ioThreadPool = ioThreadPool;
        this.batchCount = batchCount;
        this.closed = false;
    }

    @Override
    public void run() {
        this.loopMoveBatches();
        LOGGER.debug("Beginning shutdown of mover thread");
        List<ProducerBatch> incompleteBatches = this.incompleteBatches();
        LOGGER.debug("Submit incomplete batches, size={}", (Object)incompleteBatches.size());
        this.submitIncompleteBatches(incompleteBatches);
        LOGGER.debug("Shutdown of mover thread has completed");
    }

    private void loopMoveBatches() {
        while (!this.closed) {
            try {
                this.moveBatches();
            }
            catch (Exception e) {
                LOGGER.error("Uncaught exception in mover, e=", (Throwable)e);
            }
        }
    }

    private void moveBatches() {
        LOGGER.debug("Prepare to move expired batches from accumulator and retry queue to ioThreadPool");
        this.doMoveBatches();
        LOGGER.debug("Move expired batches successfully");
    }

    private void doMoveBatches() {
        ExpiredBatches expiredBatches = this.accumulator.expiredBatches();
        LOGGER.debug("Expired batches from accumulator, size={}, remainingMs={}", (Object)expiredBatches.getBatches().size(), (Object)expiredBatches.getRemainingMs());
        for (ProducerBatch b : expiredBatches.getBatches()) {
            this.ioThreadPool.submit(this.createSendProducerBatchTask(b));
        }
        List<ProducerBatch> expiredRetryBatches = this.retryQueue.expiredBatches(expiredBatches.getRemainingMs());
        LOGGER.debug("Expired batches from retry queue, size={}", (Object)expiredRetryBatches.size());
        for (ProducerBatch b : expiredRetryBatches) {
            this.ioThreadPool.submit(this.createSendProducerBatchTask(b));
        }
    }

    private List<ProducerBatch> incompleteBatches() {
        List<ProducerBatch> incompleteBatches = this.accumulator.remainingBatches();
        incompleteBatches.addAll(this.retryQueue.remainingBatches());
        return incompleteBatches;
    }

    private void submitIncompleteBatches(List<ProducerBatch> incompleteBatches) {
        for (ProducerBatch b : incompleteBatches) {
            this.ioThreadPool.submit(this.createSendProducerBatchTask(b));
        }
    }

    private SendProducerBatchTask createSendProducerBatchTask(ProducerBatch batch) {
        return new SendProducerBatchTask(batch, this.producerConfig, this.clientPool, this.retryQueue, this.successQueue, this.failureQueue, this.batchCount);
    }

    public void close() {
        this.closed = true;
        this.interrupt();
    }
}

