/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.space.SpaceId;
import com.alipay.sofa.common.utils.StringUtil;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.slf4j.Log4jLogger;
import org.apache.logging.slf4j.Log4jMarkerFactory;
import org.slf4j.Logger;

public class Log4j2LoggerSpaceFactory
extends AbstractLoggerSpaceFactory {
    private final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();
    private final SpaceId spaceId;
    private final Properties properties;
    private final LoggerContext loggerContext;
    private final URL confFile;
    private final Log4jMarkerFactory markerFactory = new Log4jMarkerFactory();
    private ConsoleAppender appender;

    public Log4j2LoggerSpaceFactory(SpaceId spaceId, Properties properties, URL confFile, String source) throws Throwable {
        super(source);
        this.spaceId = spaceId;
        this.properties = properties;
        this.confFile = confFile;
        this.loggerContext = this.initialize();
        this.attachConsoleAppender();
    }

    private LoggerContext initialize() throws Throwable {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            ThreadContext.put((String)((String)entry.getKey()), (String)this.properties.getProperty((String)entry.getKey()));
        }
        LoggerContext context = new LoggerContext(this.spaceId.getSpaceName(), null, this.confFile.toURI());
        Configuration config = ConfigurationFactory.getInstance().getConfiguration(context, this.spaceId.getSpaceName(), this.confFile.toURI(), this.getClass().getClassLoader());
        if (config == null) {
            throw new RuntimeException("No log4j2 configuration are found.");
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            config.getProperties().put((String)entry.getKey(), (String)entry.getValue());
        }
        Properties systemProperties = System.getProperties();
        Set<String> sysKeys = systemProperties.stringPropertyNames();
        for (String key : sysKeys) {
            String value = systemProperties.getProperty(key);
            if (key == null || value == null) continue;
            config.getProperties().put(key, value);
        }
        context.start(config);
        return context;
    }

    private void attachConsoleAppender() {
        String value = this.properties.getProperty(String.format("sofa.middleware.log.%s.console", this.spaceId.getSpaceName()));
        if (StringUtil.isEmpty(value)) {
            value = this.properties.getProperty("sofa.middleware.log.console");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            this.appender = this.createConsoleAppender();
            this.loggerContext.addFilter((Filter)new AbstractFilter(){

                private void process(org.apache.logging.log4j.core.Logger logger) {
                    if (CommonLoggingConfigurations.shouldAttachConsoleAppender(logger.getName())) {
                        logger.get().addAppender((Appender)Log4j2LoggerSpaceFactory.this.appender, logger.getLevel(), null);
                    }
                }

                public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
                    this.process(logger);
                    return Filter.Result.NEUTRAL;
                }

                public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
                    this.process(logger);
                    return Filter.Result.NEUTRAL;
                }

                public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
                    this.process(logger);
                    return Filter.Result.NEUTRAL;
                }
            });
        }
    }

    @Override
    public Logger setLevel(String loggerName, AdapterLevel adapterLevel) {
        String key = "ROOT".equals(loggerName) ? "" : loggerName;
        org.apache.logging.log4j.core.Logger log4j2Logger = this.loggerContext.getLogger(key);
        Level log4j2Level = this.toLog4j2Level(adapterLevel);
        log4j2Logger.setLevel(log4j2Level);
        return this.getLogger(loggerName);
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)this.loggerMap.get(name);
        if (logger != null) {
            return logger;
        }
        this.loggerMap.putIfAbsent(name, this.newLogger(name, this.loggerContext));
        return (Logger)this.loggerMap.get(name);
    }

    private ConsoleAppender createConsoleAppender() {
        String logPattern = this.properties.getProperty("sofa.middleware.log.console.log4j2.pattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p %X{PID} --- [%15.15t] %-40.40logger{39} : %m%n");
        Level level = this.getConsoleLevel();
        PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(logPattern).build();
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)level, (Filter.Result)Filter.Result.NEUTRAL, (Filter.Result)Filter.Result.DENY);
        ConsoleAppender.Builder builder = (ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setLayout((Layout)patternLayout)).setName("CONSOLE")).setFilter((Filter)filter);
        ConsoleAppender appender = builder.build();
        appender.start();
        return appender;
    }

    private Level getConsoleLevel() {
        String defaultLevel = this.properties.getProperty("sofa.middleware.log.console.level", "INFO");
        String level = this.properties.getProperty(String.format("sofa.middleware.log.%s.console.level", this.spaceId), defaultLevel);
        return Level.toLevel((String)level);
    }

    private Logger newLogger(String name, LoggerContext loggerContext) {
        String key = "ROOT".equals(name) ? "" : name;
        return new Log4jLogger(this.markerFactory, (ExtendedLogger)loggerContext.getLogger(key), name);
    }

    private Level toLog4j2Level(AdapterLevel adapterLevel) {
        if (adapterLevel == null) {
            throw new IllegalStateException("AdapterLevel is NULL when adapter to log4j2.");
        }
        return switch (adapterLevel) {
            case AdapterLevel.TRACE -> Level.TRACE;
            case AdapterLevel.DEBUG -> Level.DEBUG;
            case AdapterLevel.INFO -> Level.INFO;
            case AdapterLevel.WARN -> Level.WARN;
            case AdapterLevel.ERROR -> Level.ERROR;
            default -> throw new IllegalStateException(String.valueOf((Object)adapterLevel) + " is unknown when adapter to log4j2.");
        };
    }
}

