/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.strategy;

import java.util.Base64;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.strategy.CryptorStrategy;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptorStrategyFactory {
    public static final String DECRYPT = "decrypt";
    public static final String ENCRYPT = "encrypt";
    private static final Logger LOG = LoggerFactory.getLogger(CryptorStrategyFactory.class);

    private CryptorStrategyFactory() {
    }

    public static CryptorStrategy newInstance(String strategyName) {
        return (CryptorStrategy)ExtensionLoader.getExtensionLoader(CryptorStrategy.class).getJoin(strategyName);
    }

    public static String match(CryptorRuleHandler ruleHandle, String data) {
        switch (ruleHandle.getWay()) {
            case "decrypt": {
                return CryptorStrategyFactory.decrypt(ruleHandle.getStrategyName(), ruleHandle.getDecryptKey(), data);
            }
            case "encrypt": {
                return CryptorStrategyFactory.encrypt(ruleHandle.getStrategyName(), ruleHandle.getEncryptKey(), data);
            }
        }
        return null;
    }

    private static String encrypt(String strategyName, String key, String data) {
        try {
            return CryptorStrategyFactory.newInstance(strategyName).encrypt(key, data);
        }
        catch (Exception e) {
            LOG.error("encrypt data error: ", (Throwable)e);
            return null;
        }
    }

    private static String decrypt(String strategyName, String key, String encryptData) {
        try {
            byte[] inputByte = Base64.getMimeDecoder().decode(encryptData);
            return CryptorStrategyFactory.newInstance(strategyName).decrypt(key, inputByte);
        }
        catch (Exception e) {
            LOG.error("decrypt data error: ", (Throwable)e);
            return null;
        }
    }
}

