/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

public abstract class EnvironmentUtils {
    public static final String PROPERTY_NAME_SEPARATOR = ".";
    public static final String DUBBO_PREFIX = "dubbo";

    public static Map<String, Object> extractProperties(ConfigurableEnvironment environment) {
        return Collections.unmodifiableMap(EnvironmentUtils.doExtraProperties(environment));
    }

    private static Map<String, Object> doExtraProperties(ConfigurableEnvironment environment) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Map<String, PropertySource<?>> map = EnvironmentUtils.doGetPropertySources(environment);
        for (PropertySource<?> source : map.values()) {
            EnumerablePropertySource propertySource;
            Object[] propertyNames;
            if (!(source instanceof EnumerablePropertySource) || ObjectUtils.isEmpty((Object[])(propertyNames = (propertySource = (EnumerablePropertySource)source).getPropertyNames()))) continue;
            for (Object propertyName : propertyNames) {
                if (properties.containsKey(propertyName)) continue;
                properties.put((String)propertyName, propertySource.getProperty((String)propertyName));
            }
        }
        return properties;
    }

    private static Map<String, PropertySource<?>> doGetPropertySources(ConfigurableEnvironment environment) {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = environment.getPropertySources();
        for (PropertySource source : sources) {
            EnvironmentUtils.extract("", map, source);
        }
        return map;
    }

    private static void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                EnvironmentUtils.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }

    public static SortedMap<String, String> filterDubboProperties(ConfigurableEnvironment environment) {
        TreeMap<String, String> dubboProperties = new TreeMap<String, String>();
        Map<String, Object> properties = EnvironmentUtils.extractProperties(environment);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            if (!propertyName.startsWith("dubbo.") || entry.getValue() == null) continue;
            dubboProperties.put(propertyName, environment.resolvePlaceholders(entry.getValue().toString()));
        }
        return Collections.unmodifiableSortedMap(dubboProperties);
    }
}

